<?php
    session_start();
    include("../../config/db.php");
    include("../../config/conexion.php");

    // 1. Obtener ID de la factura/cotización
    $id_factura = (isset($_GET['id_factura']) && !empty($_GET['id_factura'])) ? intval($_GET['id_factura']) : 0;

    // 2. Buscar en la base de datos
    $sql_count = mysqli_query($con, "SELECT * FROM facturas WHERE id_factura='".$id_factura."'");
    
    if (mysqli_num_rows($sql_count) == 0) {
        echo "<script>alert('Documento no encontrado');window.close();</script>";
        exit;
    }

    $rw_factura = mysqli_fetch_array($sql_count);
    $tienda1 = $rw_factura['tienda']; 

    // =========================================================================
    // 3. SISTEMA DE SEGURIDAD (EL CANDADO)
    // =========================================================================
    
    // A. ¿El usuario es administrador logueado?
    $es_admin = (isset($_SESSION['user_login_status']) && $_SESSION['user_login_status'] == 1);

    // B. Verificación de Hash (Llave)
    $hash_db = $rw_factura['cod_hash']; 
    $hash_url = isset($_GET['hash']) ? $_GET['hash'] : '';

    // --- CORRECCIÓN CLAVE ---
    // Si la cotización es antigua y no tiene hash en la BD, generamos uno temporal
    // para que coincida con el que genera buscar_cotizacion.php
    if(empty($hash_db)){
        $hash_db = md5($id_factura . 'SoundCrowSecret');
    }
    // ------------------------

    // Si NO es admin Y el hash del link no coincide con el de la BD (o el generado) -> BLOQUEAR
    if (!$es_admin) {
        if ($hash_url == '' || $hash_url !== $hash_db) {
            die('
                <div style="font-family:sans-serif; text-align:center; padding:50px; color:#333; background:#f9fafb; height:100vh;">
                    <div style="max-width:400px; margin:auto; background:white; padding:30px; border-radius:10px; box-shadow:0 10px 25px rgba(0,0,0,0.1);">
                        <h2 style="color:#ef4444; margin-top:0;">Acceso Restringido</h2>
                        <p style="color:#6b7280;">El enlace de seguridad es inválido o ha expirado.</p>
                        <p style="font-size:12px; color:#9ca3af;">Error: Hash mismatch</p>
                    </div>
                </div>
            ');
        }
    }
    // =========================================================================

    // Variables para el PDF
    $numero_factura = $rw_factura['numero_factura'];
    $id_cliente     = $rw_factura['id_cliente'];
    $id_vendedor    = $rw_factura['id_vendedor'];
    $fecha_factura  = $rw_factura['fecha_factura'];
    $condiciones    = $rw_factura['condiciones'];
    $simbolo_moneda = $rw_factura['moneda'];
    $estado         = $rw_factura['estado_factura'];
    $folio          = $rw_factura['folio'];

    require_once(dirname(__FILE__).'/../html2pdf.class.php');
    
    ob_start();
    include(dirname(__FILE__).'/res/ver_factura_html.php'); 
    $content = ob_get_clean();

    try {
        $html2pdf = new HTML2PDF('P', 'A4', 'es', true, 'UTF-8', array(0, 0, 0, 0));
        $html2pdf->pdf->SetDisplayMode('fullpage');
        $html2pdf->writeHTML($content, isset($_GET['vuehtml']));
        $nombre_archivo = $folio . '-' . str_pad($numero_factura, 8, "0", STR_PAD_LEFT) . '.pdf';
        $html2pdf->Output($nombre_archivo);
    }
    catch(HTML2PDF_exception $e) {
        echo $e;
        exit;
    }
?>