<?php
	session_start();
	if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
        header("location: ../../login.php");
		exit;
    }
	
    /* Connect To Database*/
	include("../../config/db.php");
	include("../../config/conexion.php");
	
    $id_producto = intval($_GET['id_producto']);
    
    // VALORES PARA FILAS PEGADAS (4 Columnas)
    $largo = 0;
    $ancho = 0;
    $cant = 1;
    $med1 = 0;
    $med2 = 0; // Por defecto 0 para que estén pegadas
         
    if (isset($_GET['largo'])){$largo=$_GET['largo'];}
    if (isset($_GET['ancho'])){$ancho=$_GET['ancho'];}
    if (isset($_GET['med1'])){$med1=$_GET['med1'];}
    if (isset($_GET['med2'])){$med2=$_GET['med2'];}
    if (isset($_GET['cant'])){$cant=$_GET['cant'];}
        
	$sql_count = mysqli_query($con,"select * from products where id_producto='".$id_producto."'");
	$count = mysqli_num_rows($sql_count);
	
    if ($count == 0) {
        echo "<script>alert('Producto no encontrado'); window.close();</script>";
        exit;
	}

	$sql_producto = mysqli_query($con,"select * from products where id_producto='".$id_producto."'");
	$rw_producto = mysqli_fetch_array($sql_producto);
    
    $barras = $rw_producto['barras'];
    $nombre_producto = $rw_producto['nombre_producto']; 
    $codigo_producto = $rw_producto['codigo_producto']; 
	$precio_producto = $rw_producto['precio_producto']; 
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Imprimir Etiquetas (Pegadas) | SoundCrow</title>
    
    <link rel="icon" href="../../logo.png" type="image/png">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        body {
            background-color: #f1f5f9;
            font-family: 'Plus Jakarta Sans', sans-serif;
            margin: 0;
            padding: 0;
        }

        /* --- CONFIGURACIÓN --- */
        .config-wrapper {
            max-width: 600px;
            margin: 40px auto;
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            overflow: hidden;
        }

        .config-header {
            background: linear-gradient(135deg, #0f172a 0%, #1d4ed8 100%);
            color: white;
            padding: 20px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .config-header h3 { margin: 0; font-size: 18px; font-weight: 700; text-transform: uppercase; letter-spacing: 1px; }
        .config-header i { font-size: 24px; opacity: 0.8; }

        .config-body { padding: 30px; }
        .form-group { margin-bottom: 20px; }
        .form-label { display: block; font-size: 12px; font-weight: 700; color: #64748b; text-transform: uppercase; margin-bottom: 8px; }
        .form-control { width: 100%; padding: 12px; border: 2px solid #e2e8f0; border-radius: 8px; font-size: 14px; background: #f8fafc; color: #334155; box-sizing: border-box; transition: all 0.3s; }
        .form-control:focus { border-color: #3b82f6; background: white; outline: none; }

        .btn-generate {
            width: 100%; padding: 14px; background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
            color: white; border: none; border-radius: 50px; font-weight: 700; font-size: 14px;
            text-transform: uppercase; cursor: pointer; transition: transform 0.2s, box-shadow 0.2s;
        }
        .btn-generate:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(37, 99, 235, 0.4); }

        /* --- ETIQUETAS --- */
        .fila-etiquetas {
            display: flex; 
            flex-direction: row;
            justify-content: center;
            width: 100%;
            page-break-inside: avoid;
            margin: 0; /* Asegurar margen cero */
            padding: 0;
        }

        .etiqueta-contenedor {
            border: 1px dashed #cbd5e1; /* Borde guia visible solo en pantalla */
            overflow: hidden;
            background: white;
            font-family: Arial, Helvetica, sans-serif;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 1px;
            box-sizing: border-box;
            margin-bottom: 0; /* Sin margen abajo */
        }
        
        .etiqueta-content { width: 100%; text-align: center; line-height: 1; }

        .texto-nombre {
            font-size: 11px;
            font-weight: 900;
            display: block;
            margin-bottom: 1px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            text-transform: uppercase;
            color: #000;
        }

        .texto-info {
            font-size: 10px;
            font-weight: 600;
            display: block;
            margin-bottom: 1px;
            color: #000;
        }

        .barcode-img { 
            max-width: 100%; 
            height: 38px;
            display: block; 
            margin: 0 auto;
        }

        .fab-print {
            position: fixed; bottom: 30px; right: 30px; background-color: #2563eb; color: white;
            width: 60px; height: 60px; border-radius: 50%; display: flex; align-items: center;
            justify-content: center; box-shadow: 0 4px 15px rgba(0,0,0,0.3); cursor: pointer;
            font-size: 24px; z-index: 1000; border: none; transition: all 0.3s;
        }
        .fab-print:hover { transform: scale(1.1); background-color: #1d4ed8; }

        @media print {
            body { background: white; margin: 0; }
            .config-wrapper, .fab-print { display: none; }
            .etiqueta-contenedor { border: none; }
            @page { margin: 4mm; } 
        }
    </style>

    <script>
    function printPantalla() { window.print(); }
    </script>
</head>

<body id="cuerpoPagina">

    <?php 
    // MODO CONFIGURACIÓN
    if($largo==0 and $ancho==0 and $cant==1){
    ?>
    
    <div class="config-wrapper">
        <div class="config-header">
            <h3><i class="fas fa-cog"></i> Configurar 4 Columnas</h3>
            <i class="fas fa-barcode"></i>
        </div>
        
        <form method="GET" action="ver_producto.php" class="config-body">
            <input type="hidden" name="id_producto" value="<?php echo $id_producto;?>">
            
            <div class="alert" style="background: #eff6ff; color: #1e3a8a; padding: 10px; border-radius: 8px; font-size: 12px; margin-bottom: 20px;">
                <i class="fas fa-compress"></i> Modo Compacto: Sin espacios verticales.
            </div>

            <div class="row" style="display: flex; gap: 20px; margin-bottom: 15px;">
                <div style="flex:1;">
                    <label class="form-label">Largo (mm)</label>
                    <input type="number" name="largo" value="50" class="form-control">
                </div>
                <div style="flex:1;">
                    <label class="form-label">Ancho (mm)</label>
                    <input type="number" name="ancho" value="30" class="form-control">
                </div>
            </div>

            <div class="row" style="display: flex; gap: 20px; margin-bottom: 15px;">
                <div style="flex:1;">
                    <label class="form-label">Margen Entre Columnas (mm)</label>
                    <input type="number" name="med1" value="1" class="form-control">
                </div>
                <div style="flex:1;">
                    <label class="form-label">Margen Superior (mm)</label>
                    <input type="number" name="med2" value="0" class="form-control">
                </div>
            </div>

            <div class="form-group">
                <label class="form-label">Cantidad de FILAS</label>
                <input type="number" min="1" max="1000" name="cant" value="1" class="form-control">
            </div>

            <button type="submit" class="btn-generate">
                Generar Ticket <i class="fas fa-th" style="margin-left:8px;"></i>
            </button>
        </form>
    </div>

    <?php        
    // MODO GENERACIÓN DE ETIQUETAS
    } elseif($largo>0 and $ancho>0 and $cant>=1){
       
       echo '<button class="fab-print" onclick="printPantalla()" title="Imprimir"><i class="fas fa-print"></i></button>';
       
       // Bucle de FILAS
       for($i=1; $i<=$cant; $i++) {
           // Si es la primera fila no lleva margen superior, las siguientes usan med2
           $margin_top = ($i == 1) ? 0 : $med2;
           $estilo_fila = "margin-top: " . $margin_top . "mm;";
    ?> 
        <div class="fila-etiquetas" style="<?php echo $estilo_fila; ?>">     
            
            <?php 
            // Bucle de COLUMNAS (4 por fila)
            for($j=1; $j<=4; $j++) { 
                $margin_left = ($j > 1) ? $med1 : 0;
                $estilo_columna = "width:{$largo}mm; height:{$ancho}mm; margin-left:{$margin_left}mm;";
            ?>
            <div class="etiqueta-contenedor" style="<?php echo $estilo_columna; ?>">
                <div class="etiqueta-content">
                    <span class="texto-nombre"><?php echo substr($nombre_producto, 0, 22);?></span>
                    <span class="texto-info">
                        COD: <?php echo $codigo_producto;?> | <strong>S/ <?php echo number_format($precio_producto, 2);?></strong>
                    </span>
                    <img src='../../ajax/codigos/<?php echo $barras;?>.png' class="barcode-img">
                </div>
            </div>
            <?php } // Fin bucle columnas ?>

        </div>
    
    <?php
       } // Fin bucle filas
    } 
    ?>

</body>
</html>