<?php
session_start();
if (!isset($_SESSION['user_login_status']) || $_SESSION['user_login_status'] != 1) {
    header("location: ../../login.php");
    exit;
}
/* DB */
include("../../config/db.php");
include("../../config/conexion.php");

/* ====== Entrada segura ====== */
$id_factura = isset($_GET['id_factura']) ? (int) $_GET['id_factura'] : 0;

/* ====== Config locales ====== */
$MONEDA  = 'S/';       
$IVA     = 0.18;       
$NOM_IVA = 'IGV';

$sql_count = mysqli_query($con, "SELECT * FROM facturas WHERE id_factura='$id_factura'");
if (!$sql_count || mysqli_num_rows($sql_count) === 0) {
    echo "Comprobante no encontrado.";
    exit;
}

$sql_factura  = mysqli_query($con, "SELECT * FROM facturas WHERE id_factura='$id_factura' LIMIT 1");
$rw_factura   = mysqli_fetch_array($sql_factura);
$numero_factura = (int)$rw_factura['numero_factura'];
$folio          = $rw_factura['folio'];
$id_cliente     = (int)$rw_factura['id_cliente'];
$fecha_factura  = $rw_factura['fecha_factura'];
$condiciones    = (int)$rw_factura['condiciones'];
$estado         = (int)$rw_factura['estado_factura'];

switch ($estado) {
    case 1:  $doc = "FACTURA ELECTRÓNICA"; break;
    case 2:  $doc = "BOLETA DE VENTA ELECTRÓNICA"; break;
    case 5:  $doc = "NOTA DE DÉBITO ELECTRÓNICA"; break;
    case 6:  $doc = "NOTA DE CRÉDITO ELECTRÓNICA"; break;
    case 8:  $doc = "COTIZACIÓN"; break;
    default: $doc = "NOTA DE VENTA";
}

$condiciones1 = ($condiciones == 4) ? "Crédito" : "Contado";

/* Sucursal */
$tienda1 = (int)$_SESSION['tienda'];
$sql_sucursal = mysqli_query($con,"SELECT * FROM sucursal WHERE tienda='$tienda1' LIMIT 1");
$rw_sucursal  = mysqli_fetch_array($sql_sucursal);
$logo   = $rw_sucursal['foto'];
$dir    = $rw_sucursal['direccion'];
$nombre = $rw_sucursal['nombre'];
$ruc    = $rw_sucursal['ruc'];

/* Cliente */
$sql_cliente = mysqli_query($con,"SELECT * FROM clientes WHERE id_cliente='$id_cliente' LIMIT 1");
$rw_cliente  = mysqli_fetch_array($sql_cliente);
$doc_cliente = !empty($rw_cliente['doc']) ? $rw_cliente['doc'] : (!empty($rw_cliente['dni']) ? $rw_cliente['dni'] : '');
$tipo_doc = !empty($rw_cliente['doc']) ? "R.U.C" : "D.N.I";

$docu = $folio."-".str_pad($numero_factura, 8, "0", STR_PAD_LEFT);

/* Detalle */
$sql_det = mysqli_query($con, "SELECT * FROM detalle_factura WHERE numero_factura=$numero_factura AND tienda=$tienda1 AND tipo_doc='$estado' AND id_cliente='$id_cliente'");
?>
<!doctype html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <style>
        /* CONFIGURACIÓN PARA TICKETERA: Evita división de caras */
        :root { --ticket-w: 80mm; } /* Cambiar a 90mm si el papel es más ancho */

        body { 
            margin: 0; 
            padding: 0; 
            background: #fff; 
            font-family: 'Courier New', Courier, monospace; 
            font-size: 12px; 
            color: #000;
        }

        @page { 
            size: var(--ticket-w) auto; 
            margin: 0; 
        }

        @media print {
            .no-print { display: none !important; }
            body, html { height: auto !important; overflow: visible !important; }
            .zona_impresion { width: 100% !important; padding: 2mm; margin: 0 !important; }
            /* Evita que los elementos se corten entre páginas inexistentes */
            .table-items, tr, td, img, .divider { 
                page-break-inside: avoid !important; 
                break-inside: avoid !important; 
            }
        }

        .zona_impresion { 
            width: var(--ticket-w); 
            margin: 0 auto; 
            padding: 10px; 
            box-sizing: border-box; 
        }

        .center { text-align: center; }
        .right { text-align: right; }
        .bold { font-weight: bold; }
        
        .logo-ticket { 
            max-width: 140px; 
            filter: grayscale(100%) contrast(1.5); 
            margin-bottom: 5px;
        }

        .table-items { width: 100%; border-collapse: collapse; margin-top: 5px; font-size: 11px; }
        .table-items th { border-bottom: 1px dashed #000; border-top: 1px dashed #000; padding: 4px 0; text-align: left; }
        .table-items td { padding: 4px 0; vertical-align: top; }

        .divider { border-top: 1px dashed #000; margin: 8px 0; }
    </style>
</head>
<body>

<div class="no-print" style="padding:10px; background:#f5f5f5; border-bottom:1px solid #ddd; text-align:center;">
    <button onclick="window.print();" style="padding:8px 20px; cursor:pointer; font-weight:bold;">🖨️ IMPRIMIR COMPROBANTE</button>
</div>

<div class="zona_impresion">
    <div class="center">
        <?php if(!empty($logo)): ?>
            <img src="<?=htmlspecialchars($logo)?>" class="logo-ticket"><br>
        <?php endif; ?>
        <strong style="font-size: 14px;"><?=htmlspecialchars($nombre)?></strong><br>
        RUC: <?=htmlspecialchars($ruc)?><br>
        <?=htmlspecialchars($dir)?><br>
        <div class="divider"></div>
        <strong><?=htmlspecialchars($doc)?></strong><br>
        <strong><?=htmlspecialchars($docu)?></strong>
    </div>

    <div style="margin-top: 10px; font-size: 11px; line-height: 1.3;">
        FECHA: <?=date("d/m/Y H:i", strtotime($fecha_factura))?><br>
        CLIENTE: <?=htmlspecialchars($rw_cliente['nombre_cliente'] ?? 'VARIOS')?><br>
        DIRECCIÓN: <?=htmlspecialchars($rw_cliente['direccion_cliente'] ?? '-')?><br>
        <?=$tipo_doc?>: <?=htmlspecialchars($doc_cliente)?><br>
        PAGO: <?=htmlspecialchars($condiciones1)?><br>
    </div>

    <table class="table-items">
        <thead>
            <tr>
                <th style="width: 12%;">CANT</th>
                <th style="width: 48%;">DESCRIPCION</th>
                <th style="width: 20%; text-align: right;">P.U.</th>
                <th style="width: 20%; text-align: right;">TOTAL</th>
            </tr>
        </thead>
        <tbody>
        <?php
        $sumador_total = 0;
        while($row = mysqli_fetch_array($sql_det)) {
            $cant = (float)$row['cantidad'];
            $p_unit = (float)$row['precio_venta'];
            $p_total = $cant * $p_unit;
            $sumador_total += $p_total;
            
            $id_p = $row['id_producto'];
            $nombre_p = $id_p; 
            if ($id_p > 0 && is_numeric($id_p)) {
                $q_p = mysqli_query($con, "SELECT nombre_producto, marca FROM products WHERE id_producto='$id_p'");
                $r_p = mysqli_fetch_array($q_p);
                $nombre_p = ($r_p['nombre_producto'] ?? '') . " " . ($r_p['marca'] ?? '');
            }
        ?>
            <tr>
                <td><?=number_format($cant, 0)?></td>
                <td style="text-transform: uppercase;"><?=htmlspecialchars($nombre_p)?></td>
                <td style="text-align: right;"><?=number_format($p_unit, 2)?></td>
                <td style="text-align: right;"><?=number_format($p_total, 2)?></td>
            </tr>
        <?php } ?>
        </tbody>
    </table>

    <div class="divider"></div>
    
    <div class="right" style="line-height: 1.4;">
        <?php if (in_array($estado,[1,5,6])): ?>
            OP. GRAVADA: <?=$MONEDA?> <?=number_format($sumador_total/1.18, 2)?><br>
            IGV (18%): <?=$MONEDA?> <?=number_format($sumador_total - ($sumador_total/1.18), 2)?><br>
        <?php endif; ?>
        <strong style="font-size: 14px;">TOTAL: <?=$MONEDA?> <?=number_format($sumador_total, 2)?></strong>
    </div>

    <div class="center" style="margin-top:5px; font-size: 10px; text-transform: uppercase;">
        <strong>SON:</strong> <?=convertir((int)$sumador_total)?> CON <?=explode(".", number_format($sumador_total, 2))[1]?>/100 SOLES
    </div>

    <div class="center" style="margin-top:5px;">
        <img src="qr/<?=$id_factura?>.png" width="70"><br>
        <span style="font-size: 9px;">HASH: <?=htmlspecialchars($rw_factura['cod_hash'] ?? '')?></span><br>
        <small>Autorizado mediante resolucion de intendencia Nº 034-005-0005315</small><br>
        <small>Representación impresa de la <?=htmlspecialchars($doc)?>.</small><br>
        <div class="divider"></div>
        <strong>¡GRACIAS POR SU PREFERENCIA!</strong>
    </div>
    
    <div style="height: 10mm;"></div>
</div>

<?php
function unidad($n){ $u=["","UN","DOS","TRES","CUATRO","CINCO","SEIS","SIETE","OCHO","NUEVE"]; return $u[$n]." "; }
function decena($n){
    if($n>29){ $d=["","","","TREINTA","CUARENTA","CINCUENTA","SESENTA","SETENTA","OCHENTA","NOVENTA"]; $u=$n%10; return $d[(int)($n/10)].($u>0?" Y ".unidad($u):" "); }
    if($n>19) return ($n==20?"VEINTE ":"VEINTI".unidad($n-20));
    if($n>9){ $e=[10=>"DIEZ",11=>"ONCE",12=>"DOCE",13=>"TRECE",14=>"CATORCE",15=>"QUINCE",16=>"DIECISEIS",17=>"DIECISIETE",18=>"DIECIOCHO",19=>"DIECINUEVE"]; return $e[$n]." "; }
    return unidad($n);
}
function centena($n){
    if($n>99){ if($n==100) return "CIEN "; $c=["","CIENTO","DOSCIENTOS","TRESCIENTOS","CUATROCIENTOS","QUINIENTOS","SEISCIENTOS","SETECIENTOS","OCHOCIENTOS","NOVECIENTOS"]; return $c[(int)($n/100)]." ".decena($n%100); }
    return decena($n);
}
function miles($n){ if($n>=1000 && $n<2000) return "MIL ".centena($n%1000); if($n>=2000 && $n<10000) return unidad((int)($n/1000))." MIL ".centena($n%1000); return centena($n); }
function decmiles($n){ if($n>=10000 && $n<100000) return decena((int)($n/1000))." MIL ".centena($n%1000); return miles($n); }
function millon($n){ if($n>=1000000 && $n<2000000) return "UN MILLON ".decmiles($n%1000000); if($n>=2000000 && $n<10000000) return unidad((int)($n/1000000))." MILLONES ".decmiles($n%1000000); return decmiles($n); }
function convertir($n){ return millon($n); }
?>
</body>
</html>