<?php
session_start();
include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
    header("location: login.php"); exit;
}
$sql1="select * from users where user_id=$_SESSION[user_id]";
$rw1=mysqli_query($con,$sql1);
$rs1=mysqli_fetch_array($rw1);
$modulo=$rs1["accesos"];
$a = explode(".", $modulo); 
if($a[3]==0){ header("location:error.php"); }

// Variables de empresa
$sql2="select * from datosempresa where id_emp=1";
$rw2=mysqli_query($con,$sql2);
$rs2=mysqli_fetch_array($rw2);
$alerta=$rs2["alerta"];
$precio2=$rs2["precio2"];
$precio3=$rs2["precio3"];
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Inventario | SoundCrow</title>
    <link rel="icon" href="logo.png" type="image/png">

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    
    <link href="css/datatables/tools/css/dataTables.tableTools.css" rel="stylesheet">
    <link href="css/select/select2.min.css" rel="stylesheet">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">

    <style>
        body { background-color: #f1f5f9; font-family: 'Plus Jakarta Sans', sans-serif; }
        
        .form-header {
            background: linear-gradient(135deg, #0f172a 0%, #1d4ed8 100%);
            color: white; padding: 25px 40px; border-radius: 15px 15px 0 0;
            display: flex; justify-content: space-between; align-items: center;
            margin-top: 60px; box-shadow: 0 10px 25px rgba(15, 23, 42, 0.2);
        }
        .form-header h3 { margin: 0; font-size: 20px; font-weight: 800; letter-spacing: 1px; text-transform: uppercase; }
        .form-header p { margin: 5px 0 0 0; font-size: 13px; opacity: 0.8; font-weight: 500; }
        .header-icon { font-size: 32px; opacity: 0.8; color: rgba(255,255,255,0.8); }

        .form-container {
            background: white; padding: 30px; border-radius: 0 0 15px 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.06); margin-bottom: 50px;
            border: 1px solid #e2e8f0; border-top: none;
        }

        .search-wrapper { position: relative; width: 100%; max-width: 600px; }
        .search-input {
            border: 2px solid #e2e8f0; border-radius: 50px;
            padding: 12px 25px 12px 55px; height: 50px; font-size: 15px;
            background-color: #f8fafc; width: 100%; transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            color: #334155; font-weight: 500;
        }
        .search-icon-overlay {
            position: absolute; left: 20px; top: 50%; transform: translateY(-50%);
            color: #94a3b8; font-size: 18px; pointer-events: none; transition: color 0.3s;
        }
        .search-input:focus { background-color: #fff; border-color: #3b82f6; box-shadow: 0 4px 20px rgba(59, 130, 246, 0.15); outline: none; }
        .search-input:focus + .search-icon-overlay { color: #3b82f6; }

        .ui-autocomplete {
            background: white !important; border-radius: 12px !important;
            box-shadow: 0 15px 40px rgba(0,0,0,0.12) !important; border: 1px solid #e2e8f0 !important;
            padding: 10px 0 !important; max-height: 400px; overflow-y: auto;
            width: 600px !important; z-index: 9999 !important; font-family: 'Plus Jakarta Sans', sans-serif !important;
        }
        .ui-menu-item a {
            display: block; padding: 12px 25px !important; font-size: 14px !important;
            color: #475569 !important; border-bottom: 1px solid #f8fafc !important;
            transition: all 0.2s ease !important; cursor: pointer !important; margin: 0 !important;
        }
        .ui-menu-item a:hover {
            background: #eff6ff !important; color: #1d4ed8 !important;
            border-left: 4px solid #3b82f6 !important; padding-left: 21px !important;
            font-weight: 600 !important;
        }

        #loader_pro { margin-left: 10px; display: inline-block; vertical-align: middle; }
        #resultados { margin-top: 10px; } 
        .outer_div { padding: 0; }
        .sr-only { position: absolute; width: 1px; height: 1px; padding: 0; margin: -1px; overflow: hidden; clip: rect(0, 0, 0, 0); border: 0; }
        
        /* --- BOTONES PREMIUM (Estilo SoundCrow) --- */
        .btn-action {
            border: none;
            border-radius: 50px;
            width: 38px;
            height: 38px;
            margin: 0 3px;
            font-size: 14px;
            transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            color: white;
            cursor: pointer;
        }
        
        .btn-action i { margin: 0; }

        /* Editar (Naranja) */
        .btn-edit { background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); }
        .btn-edit:hover { transform: translateY(-3px) scale(1.1); box-shadow: 0 8px 15px rgba(245, 158, 11, 0.4); color: white; }

        /* Barras (Azul Oscuro/Índigo) */
        .btn-print { background: linear-gradient(135deg, #6366f1 0%, #4338ca 100%); }
        .btn-print:hover { transform: translateY(-3px) scale(1.1); box-shadow: 0 8px 15px rgba(99, 102, 241, 0.4); color: white; }

        /* Foto (Verde Esmeralda) */
        .btn-photo { background: linear-gradient(135deg, #10b981 0%, #059669 100%); }
        .btn-photo:hover { transform: translateY(-3px) scale(1.1); box-shadow: 0 8px 15px rgba(16, 185, 129, 0.4); color: white; }

        /* Eliminar (Rojo) */
        .btn-delete { background: linear-gradient(135deg, #ef4444 0%, #b91c1c 100%); }
        .btn-delete:hover { transform: translateY(-3px) scale(1.1); box-shadow: 0 8px 15px rgba(239, 68, 68, 0.4); color: white; }
    </style>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col">
                <div class="left_col scroll-view">
                    <div class="clearfix"></div>
                    <?php menu2(); menu1(); ?>
                </div>
            </div>
            <?php menu3(); ?>

            <div class="right_col" role="main">
                
                <?php
                    include("modal/registro_productos.php");
                    include("modal/editar_productos.php");
                    include("modal/ubicar_productos.php");
                    include("modal/editar_foto.php"); // <--- NUEVO MODAL INCLUIDO AQUÍ
                ?>

                <div class="form-header">
                    <div>
                        <h3>Inventario General</h3>
                        <p>Gestión y búsqueda de productos en el sistema.</p>
                    </div>
                    <div class="header-icon"><i class="fas fa-boxes-stacked"></i></div>
                </div>

                <div class="form-container">
                    <form class="form-horizontal" role="form" id="datos_cotizacion">
                        <div class="row">
                            <div class="col-md-12 col-sm-12 col-xs-12">
                                <div class="search-wrapper">
                                    <label for="q_pro" class="sr-only">Buscar Producto</label>
                                    <input type="text" class="search-input" id="q_pro" placeholder="Buscar por código, nombre o marca..." onkeyup='load(1);' autocomplete="off">
                                    <i class="fas fa-search search-icon-overlay"></i>
                                    <input type="hidden" id="id_producto_busqueda">
                                </div>
                                <span id="loader_pro"></span>
                            </div>
                        </div>
                    </form>
                    <hr style="border-top: 1px solid #f1f5f9; margin: 15px 0;">
                    <div id="resultados"></div>
                    <div class='outer_div'></div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="imagenModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header" style="background: linear-gradient(135deg, #0f172a 0%, #1d4ed8 100%); color: white;">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color:white; opacity:1;"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="titulo_imagen">Vista Previa</h4>
          </div>
          <div class="modal-body text-center" style="background: #f8fafc; padding: 20px;">
            <img src="" id="imagen_grande" style="max-width: 100%; max-height: 500px; border-radius: 8px; box-shadow: 0 5px 15px rgba(0,0,0,0.1);">
          </div>
        </div>
      </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="//code.jquery.com/ui/1.11.4/jquery-ui.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="js/custom.js"></script>
    <script type="text/javascript" src="js/VentanaCentrada.js"></script>
    <script src="js/select/select2.full.js"></script>
    <script src="js/pace/pace.min.js"></script>
    
    <script>
    $(document).ready(function(){
        load(1);
    });

    function load(page){
        var q = $("#q_pro").val();
        var parametros = {'action':'ajax','page':page,'q':q};
        $("#loader_pro").fadeIn('slow');
        $.ajax({
            url: './ajax/buscar_productos.php',
            data: parametros,
            beforeSend: function(objeto){
                $('#loader_pro').html('<img src="./img/ajax-loader.gif"> Cargando...');
            },
            success:function(data){
                $(".outer_div").html(data).fadeIn('slow');
                $('#loader_pro').html('');
            }
        });
    }

    $(function() {
        $("#q_pro").autocomplete({
            source: "./ajax/autocomplete/productos0.php",
            minLength: 1,
            select: function(event, ui) {
                event.preventDefault();
                $('#id_producto_busqueda').val(ui.item.id_producto);
                $('#q_pro').val(ui.item.nombre_producto);
                load(1);
            }
        });
        jQuery.ui.autocomplete.prototype._resizeMenu = function () {
            var ul = this.menu.element;
            ul.outerWidth(this.element.outerWidth());
        }
    });

    $("#q_pro").on("keydown", function( event ) {
        if (event.keyCode==$.ui.keyCode.DELETE || event.keyCode==8){
            setTimeout(function(){
                if($("#q_pro").val() == "") {
                    $('#id_producto_busqueda').val("");
                    load(1); 
                }
            }, 100);
        }
    });

    function imprimir_barra(id_producto){
        VentanaCentrada('./pdf/documentos/ver_producto.php?id_producto='+id_producto,'Factura','','1024','768','true');
    }
    
    // --- MODALES (GUARDAR Y EDITAR DATOS) ---
    $( "#guardar_producto" ).submit(function( event ) {
      $('#guardar_datos').attr("disabled", true);
      var parametros = $(this).serialize();
         $.ajax({
                type: "POST",
                url: "ajax/nuevo_producto.php",
                data: parametros,
                 beforeSend: function(objeto){
                    $("#resultados_ajax_productos").html("Mensaje: Cargando...");
                  },
                success: function(datos){
                $("#resultados_ajax_productos").html(datos);
                $('#guardar_datos').attr("disabled", false);
                load(1);
              }
        });
      event.preventDefault();
    });

    $( "#editar_producto" ).submit(function( event ) {
      $('#actualizar_datos').attr("disabled", true);
      var parametros = $(this).serialize();
         $.ajax({
                type: "POST",
                url: "ajax/editar_producto.php",
                data: parametros,
                 beforeSend: function(objeto){
                    $("#resultados_ajax2").html("Mensaje: Cargando...");
                  },
                success: function(datos){
                $("#resultados_ajax2").html(datos);
                $('#actualizar_datos').attr("disabled", false);
                load(1);
              }
        });
      event.preventDefault();
    });

    // --- NUEVO: MODAL CAMBIAR FOTO (Lógica AJAX) ---
    function cambiar_foto(id){
        $("#mod_id_foto").val(id);
        $("#preview_img").attr("src", "images/no-image.png"); // Reiniciar preview
        $("#imagefile").val(""); // Limpiar input file
        $("#resultados_ajax3").html(""); // Limpiar mensajes
    }

    // Previsualizar imagen antes de subir
    function validarImagen(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#preview_img').attr('src', e.target.result);
            }
            reader.readAsDataURL(input.files[0]);
        }
    }

    // Enviar formulario de foto con AJAX
    $( "#editar_foto" ).submit(function( event ) {
      $('#btn_guardar_foto').attr("disabled", true);
      $('#btn_guardar_foto').html('<i class="fa fa-spinner fa-spin"></i> Subiendo...');
      
      // FormData es necesario para enviar archivos por AJAX
      var parametros = new FormData(this);
      
      $.ajax({
            type: "POST",
            url: "ajax/editar_foto.php",
            data: parametros,
            contentType: false,
            cache: false,
            processData: false,
            beforeSend: function(objeto){
                $("#resultados_ajax3").html("Mensaje: Cargando...");
            },
            success: function(datos){
                $("#resultados_ajax3").html(datos);
                $('#btn_guardar_foto').attr("disabled", false);
                $('#btn_guardar_foto').html('Actualizar Foto');
                load(1); // Recargar la tabla para ver la foto nueva
            }
      });
      event.preventDefault();
    });

    function obtener_datos(id){
        var codigo_producto = $("#codigo_producto"+id).val();
        var nombre_producto = $("#nombre_producto"+id).val();
        var precio_producto = $("#precio_producto"+id).val();
        var costo_producto = $("#costo_producto"+id).val();
        var status = $("#status"+id).val();
        var cat_pro = $("#cat"+id).val();
        var inv = $("#inv"+id).val();
        var marca = $("#marca"+id).val();
        var modelo = $("#modelo"+id).val(); 
        var color = $("#color"+id).val();
        var costo = $("#costo"+id).val();
        var utilidad = $("#utilidad"+id).val();
        var und_pro = $("#und_pro"+id).val();
        var barras = $("#barras"+id).val();
        var stockmin = $("#stockmin"+id).val();

        $("#mod_id").val(id);
        $("#mod_codigo").val(codigo_producto);
        $("#mod_nombre").val(nombre_producto);
        $("#mod_precio").val(precio_producto);
        $("#mod_costo").val(costo_producto);
        $("#mod_status").val(status);
        $("#mod_cat").val(cat_pro);
        $("#mod_inv").val(inv);
        $("#mod_marca").val(marca);
        $("#mod_modelo").val(modelo);
        $("#mod_color").val(color);
        $("#soles").val(costo);
        $("#utilidad").val(utilidad);
        $("#mod_und_pro").val(und_pro);
        $("#mod_barras").val(barras);
        $("#mod_stockmin").val(stockmin);
    }

    function ubicar_datos(id){
        $( "#resultadosx" ).load( "ajax/agregar_ubicacion.php?id_producto="+id );
    }
    
    function eliminar(id){
        if(confirm("¿Realmente deseas eliminar este producto?")){
            $.ajax({
                type: "GET",
                url: "./ajax/buscar_productos.php",
                data: "id="+id,
                beforeSend: function(objeto){
                    $("#resultados").html("Mensaje: Cargando...");
                },
                success: function(datos){
                    $("#resultados").html(datos);
                    load(1);
                }
            });
        }
    }
    
    function ver_imagen(img, nombre) {
        $("#imagen_grande").attr("src", img);
        $("#titulo_imagen").text(nombre);
        $("#imagenModal").modal("show");
    }

    function validarStockEdit() {
        var stock = parseFloat($("#mod_inv").val()) || 0;
        var min = parseFloat($("#mod_stockmin").val()) || 0;
        var inputStock = $("#mod_inv");

        if (stock <= min) {
            inputStock.css({
                "background-color": "#fee2e2", 
                "color": "#b91c1c",
                "border-color": "#ef4444"
            });
        } else {
            inputStock.css({
                "background-color": "#ecfdf5", 
                "color": "#047857",
                "border-color": "#10b981"
            });
        }
    }

    $('#myModal2').on('shown.bs.modal', function () {
        validarStockEdit();
    });
    </script>
</body>
</html>