<?php
// 1. CONFIGURACIÓN TÉCNICA
error_reporting(0);
ini_set('display_errors', 0);

session_start();

// 2. CONEXIÓN Y MENÚ
include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

// 3. SEGURIDAD DE SESIÓN
if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
    header("location: login.php");
    exit;
}

// 4. PERMISOS (Índice 17 para Proveedores)
$sql1="select * from users where user_id='".$_SESSION['user_id']."'";
$rw1=mysqli_query($con,$sql1);
$rs1=mysqli_fetch_array($rw1);
$modulo=$rs1["accesos"];
$a = explode(".", $modulo); 

if($a[20]==0){
    header("location:error.php");    
    exit;
}   
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Proveedores | SoundCrow</title>
    <link rel="icon" href="logo.png">

    <script src="js/jquery.min.js"></script>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="css/formularios.css"/>
    
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        body { font-family: 'Poppins', sans-serif !important; background-color: #F0F2F5; color: #334155; }
        
        /* TARJETA PRINCIPAL */
        .sc-card {
            background: #ffffff;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.05);
            border: none;
            overflow: hidden;
            margin-bottom: 30px;
        }

        /* ENCABEZADO AZUL DEGRADADO */
        .sc-header {
            background: linear-gradient(90deg, #0a2463 0%, #2473f2 100%);
            padding: 20px 30px;
            color: white;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .sc-title {
            margin: 0;
            font-size: 18px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: white;
        }

        .sc-subtitle {
            font-size: 13px;
            color: #e2e8f0;
            font-weight: 400;
            display: block;
            margin-top: 4px;
        }

        .sc-body {
            padding: 30px;
        }

        /* BOTÓN NUEVO */
        .btn-sc-new {
            background-color: rgba(255,255,255,0.2);
            color: white;
            border: 1px solid rgba(255,255,255,0.4);
            border-radius: 50px;
            padding: 8px 20px;
            font-weight: 600;
            font-size: 13px;
            transition: all 0.3s;
        }
        .btn-sc-new:hover {
            background-color: white;
            color: #0a2463;
        }

        /* INPUTS MODERNOS */
        .form-control-sc {
            border-radius: 8px;
            border: 1px solid #e2e8f0;
            padding: 10px 15px;
            height: 45px;
            background-color: #f8fafc;
            width: 100%;
            transition: 0.3s;
        }
        .form-control-sc:focus {
            background-color: #fff;
            border-color: #2473f2;
            box-shadow: 0 0 0 3px rgba(36, 115, 242, 0.1);
            outline: none;
        }

        /* BOTONES DE EXPORTACIÓN */
        .btn-export {
            border-radius: 8px;
            height: 45px;
            padding-top: 10px; 
            margin-left: 5px;
            border: 1px solid #e2e8f0;
            background: white;
            color: #475569;
            font-weight: 500;
            transition: 0.2s;
        }
        .btn-export:hover {
            background: #f1f5f9;
            border-color: #cbd5e1;
        }
    </style>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">

            <div class="col-md-3 left_col">
                <div class="left_col scroll-view">
                    <div class="clearfix"></div>
                    <?php menu2(); menu1(); ?>
                </div>
            </div>

            <?php menu3(); ?>
      
            <div class="right_col" role="main">
                <div class="">
                    <div class="page-title"></div>
                    <div class="clearfix"></div>

                    <div class="row">
                        <div class="container">
                            
                            <div class="sc-card">
                                
                                <div class="sc-header">
                                    <div>
                                        <h3 class="sc-title"><i class="fa fa-truck"></i> PROVEEDORES</h3>
                                        <span class="sc-subtitle">Gestión de compras y abastecimiento</span>
                                    </div>
                                    <div>
                                        <button type='button' class="btn btn-sc-new" data-toggle="modal" data-target="#nuevoProveedores">
                                            <i class="fa fa-plus"></i> Nuevo Proveedor
                                        </button>
                                    </div>
                                </div>

                                <div class="sc-body">
                                    <?php
                                        include("modal/registro_proveedores.php");
                                        include("modal/editar_proveedores.php");
                                    ?>
                                    
                                    <form class="form-horizontal" onsubmit="event.preventDefault();">
                                        <div class="row" style="margin-bottom: 25px; display: flex; align-items: center; flex-wrap: wrap;">
                                            
                                            <div class="col-md-8 col-sm-7 col-xs-12">
                                                <div class="form-group" style="margin:0;">
                                                    <input type="text" class="form-control-sc" id="q" 
                                                           placeholder="🔍 Buscar proveedor por nombre, RUC o teléfono..." 
                                                           onkeyup='load(1);'>
                                                </div>
                                            </div>

                                            <div class="col-md-4 col-sm-5 col-xs-12 text-right">
                                                 <span id="loader" style="margin-right: 10px;"></span>
                                                 
                                                 <a href="descargar_proveedores.php" target="_blank" class="btn btn-export" title="Descargar Excel">
                                                    <i class="fa fa-file-excel-o text-success"></i> Excel
                                                 </a>

                                                 <a href="reporte_proveedores.php" target="_blank" class="btn btn-export" title="Descargar PDF">
                                                    <i class="fa fa-file-pdf-o text-danger"></i> PDF
                                                 </a>
                                            </div>

                                        </div>
                                    </form>

                                    <div id="resultados"></div>
                                    <div class='outer_div'></div>

                                </div>
                            </div>

                        </div>
                   </div>
                </div>
            </div>
        </div>
    </div>

    <script src="js/bootstrap.min.js"></script>
    <script src="js/progressbar/bootstrap-progressbar.min.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="js/icheck/icheck.min.js"></script>
    <script src="js/custom.js"></script>
    <script src="js/pace/pace.min.js"></script>

    <script>
        $(document).ready(function(){
            load(1);
        });

        // FUNCIÓN LOAD SIN ICONO DE CARGA
        function load(page){
            var q= $("#q").val();
            
            // Eliminamos la línea $("#loader").fadeIn('slow'); para que no aparezca el icono
            
            $.ajax({
                url:'./ajax/buscar_proveedores.php?action=ajax&page='+page+'&q='+q,
                beforeSend: function(objeto){
                    // Dejamos vacío el beforeSend para no inyectar el GIF
                    // $('#loader').html('<img src="./img/ajax-loader.gif">'); 
                },
                success:function(data){
                    $(".outer_div").html(data).fadeIn('slow');
                    $('#loader').html(''); // Aseguramos limpieza
                }
            })
        }

function eliminar(id, estado_actual){
    var q = $("#q").val();
    
    // Definir el mensaje según el estado actual (si es 1, vamos a desactivar; si es 0, a activar)
    var mensaje = "";
    if (estado_actual == 1) {
        mensaje = "¿Realmente deseas DESACTIVAR este proveedor?";
    } else {
        mensaje = "¿Realmente deseas ACTIVAR este proveedor?";
    }

    if (confirm(mensaje)){  
        $.ajax({
            type: "GET",
            url: "./ajax/buscar_proveedores.php",
            data: "id="+id+"&q="+q, // Enviamos ID y búsqueda
            beforeSend: function(objeto){
                $("#resultados").html("Mensaje: Cargando...");
            },
            success: function(datos){
                $("#resultados").html(datos);
                load(1);
                
                // Efecto para desaparecer la alerta sola
                setTimeout(function() {
                    $(".alert").fadeTo(500, 0).slideUp(500, function(){
                        $(this).remove(); 
                    });
                }, 3000);
            }
        });
    }
}

        $( "#guardar_proveedores" ).submit(function( event ) {
            $('#guardar_datos').attr("disabled", true);
            var parametros = $(this).serialize();
            $.ajax({
                type: "POST",
                url: "ajax/nuevo_proveedores.php",
                data: parametros,
                beforeSend: function(objeto){
                    $("#resultados_ajax").html("Mensaje: Cargando...");
                },
                success: function(datos){
                    $("#resultados_ajax").html(datos);
                    $('#guardar_datos').attr("disabled", false);
                    load(1);
                    setTimeout(function() { $(".alert").fadeOut(); }, 3000);
                }
            });
            event.preventDefault();
        })

        $( "#editar_proveedores" ).submit(function( event ) {
            $('#actualizar_datos').attr("disabled", true);
            var parametros = $(this).serialize();
            $.ajax({
                type: "POST",
                url: "ajax/editar_proveedores.php",
                data: parametros,
                beforeSend: function(objeto){
                    $("#resultados_ajax2").html("Mensaje: Cargando...");
                },
                success: function(datos){
                    $("#resultados_ajax2").html(datos);
                    $('#actualizar_datos').attr("disabled", false);
                    load(1);
                    setTimeout(function() { $(".alert").fadeOut(); }, 3000);
                }
            });
            event.preventDefault();
        })

        function obtener_datos(id){
            var nombre_cliente = $("#nombre_cliente"+id).val();
            var doc = $("#doc"+id).val();
            var dni = $("#dni"+id).val();
            var vendedor = $("#vendedor"+id).val();
            var telefono_cliente = $("#telefono_cliente"+id).val();
            var email_cliente = $("#email_cliente"+id).val();
            var direccion_cliente = $("#direccion_cliente"+id).val();
            var status_cliente = $("#status_cliente"+id).val();
            var departamento = $("#departamento"+id).val();
            var provincia = $("#provincia"+id).val();
            var distrito = $("#distrito"+id).val();
            var cuenta = $("#cuenta"+id).val();
            var tipo = $("#tipo"+id).val();

            $("#mod_nombre").val(nombre_cliente);
            $("#mod_doc").val(doc);
            $("#mod_dni").val(dni);
            $("#mod_ven").val(vendedor);
            $("#mod_telefono").val(telefono_cliente);
            $("#mod_email").val(email_cliente);
            $("#mod_direccion").val(direccion_cliente);
            $("#mod_estado").val(status_cliente);                      
            $("#mod_id").val(id);
            $("#mod_departamento").val(departamento);    
            $("#mod_provincia").val(provincia);    
            $("#mod_distrito").val(distrito);    
            $("#mod_cuenta").val(cuenta); 
            $("#mod_tipo").val(tipo);
        }
    </script>
</body>
</html>