<?php
session_start();
if (!isset($_SESSION['user_login_status']) || $_SESSION['user_login_status'] != 1) { exit; }

require_once ("config/db.php");
require_once ("config/conexion.php");

$id = intval($_GET['id']);

$sql = mysqli_query($con, "SELECT p.*, u.nombres as nom_trab, u.apellidos as ape_trab, u.dni as dni_trab, a.nombres as nom_admin 
                           FROM pagos_trabajadores p 
                           INNER JOIN users u ON p.id_trabajador = u.user_id 
                           INNER JOIN users a ON p.id_admin = a.user_id 
                           WHERE p.id_pago = '$id'");
$pago = mysqli_fetch_array($sql);

if(!$pago){ die("Recibo no encontrado"); }

// Datos de la empresa
$sql_emp = mysqli_query($con, "SELECT * FROM datosempresa WHERE id_emp = 1");
$empresa = mysqli_fetch_array($sql_emp);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>Recibo de Pago #<?php echo str_pad($id, 6, "0", STR_PAD_LEFT); ?></title>
    <style>
        body { font-family: 'Courier New', Courier, monospace; font-size: 14px; margin: 0; padding: 20px; background: #eee; }
        .ticket { width: 300px; max-width: 100%; background: white; padding: 20px; border-radius: 5px; margin: 0 auto; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        .center { text-align: center; }
        h3 { margin: 5px 0; font-size: 16px; font-weight: bold; }
        p { margin: 3px 0; }
        hr { border: none; border-top: 1px dashed #333; margin: 15px 0; }
        .bold { font-weight: bold; }
        @media print {
            body { background: transparent; padding: 0; }
            .ticket { box-shadow: none; border-radius: 0; margin: 0; width: 100%; }
            .no-print { display: none; }
        }
    </style>
</head>
<body onload="window.print()">
    <div class="ticket">
        <div class="center">
            <h3><?php echo $empresa['nom_emp']; ?></h3>
            <p>RUC: <?php echo $empresa['tienda']; ?></p> <p><?php echo $empresa['des_emp']; ?></p>
            <hr>
            <h3>COMPROBANTE DE PAGO</h3>
            <p>Nº RECIBO: <strong>#<?php echo str_pad($id, 6, "0", STR_PAD_LEFT); ?></strong></p>
        </div>
        <hr>
        <p><span class="bold">Fecha:</span> <?php echo date('d/m/Y H:i:s', strtotime($pago['fecha_pago'])); ?></p>
        <p><span class="bold">Trabajador:</span> <?php echo $pago['nom_trab']." ".$pago['ape_trab']; ?></p>
        <?php if(!empty($pago['dni_trab'])): ?>
        <p><span class="bold">DNI:</span> <?php echo $pago['dni_trab']; ?></p>
        <?php endif; ?>
        <p><span class="bold">Concepto:</span> <?php echo $pago['concepto']; ?></p>
        <hr>
        <div class="center">
            <h3 style="font-size: 18px;">TOTAL ENTREGADO</h3>
            <h2 style="margin: 5px 0; font-size: 24px;">S/ <?php echo number_format($pago['monto'], 2); ?></h2>
        </div>
        <hr>
        <br><br><br>
        <div class="center">
            <p>_____________________________</p>
            <p style="font-size: 12px;">Firma del Trabajador</p>
            <p style="font-size: 11px; margin-top: 15px; color:#666;">Registrado por: <?php echo $pago['nom_admin']; ?></p>
        </div>
        
        <div class="no-print center" style="margin-top: 20px;">
            <button onclick="window.print()" style="padding: 10px; background: #2473f2; color: white; border: none; border-radius: 5px; font-weight: bold; cursor:pointer;">Imprimir</button>
            <button onclick="window.close()" style="padding: 10px; margin-left: 10px; cursor:pointer;">Cerrar</button>
        </div>
    </div>
</body>
</html>