<?php
session_start();
if (!isset($_SESSION['user_login_status']) || $_SESSION['user_login_status'] != 1) { 
    exit("Acceso denegado"); 
}

require_once ("config/db.php");
require_once ("config/conexion.php");

$f_inicio = mysqli_real_escape_string($con, strip_tags($_GET['f_inicio'], ENT_QUOTES));
$f_fin = mysqli_real_escape_string($con, strip_tags($_GET['f_fin'], ENT_QUOTES));
$sucursal = mysqli_real_escape_string($con, strip_tags($_GET['sucursal'], ENT_QUOTES));

$sWhere = " WHERE DATE(c.fec_reg) BETWEEN '$f_inicio' AND '$f_fin' ";
$nombre_sucursal_reporte = "TODAS LAS SUCURSALES";

if ($sucursal != 'todas') {
    $sWhere .= " AND c.tienda = '$sucursal' ";
    $q_s = mysqli_query($con, "SELECT nombre_stand, nombre FROM sucursal WHERE id_sucursal='$sucursal'");
    if($r_s = mysqli_fetch_array($q_s)){
        $nombre_sucursal_reporte = !empty($r_s['nombre_stand']) ? $r_s['nombre_stand'] : $r_s['nombre'];
    }
}

$sWhere .= " ORDER BY c.id_caja ASC";

$query = mysqli_query($con, "SELECT c.*, s.nombre_stand, s.nombre, u.nombres as cajero 
                             FROM caja c 
                             INNER JOIN sucursal s ON c.tienda = s.id_sucursal 
                             INNER JOIN users u ON c.usuario_inicio = u.user_id 
                             $sWhere");
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>Reporte de Cajas - SoundCrow</title>
    <style>
        body { font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; color: #333; margin: 0; padding: 20px; font-size: 12px; }
        .header { text-align: center; margin-bottom: 30px; border-bottom: 2px solid #333; padding-bottom: 10px; }
        .header h2 { margin: 0 0 5px 0; font-size: 24px; text-transform: uppercase; }
        .header p { margin: 0; color: #666; font-size: 14px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px 10px; text-align: left; }
        th { background-color: #f5f5f5; font-weight: bold; text-transform: uppercase; font-size: 11px; }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
        .tfoot td { background-color: #eee; font-weight: bold; font-size: 13px; }
        @media print {
            @page { margin: 1cm; size: landscape; }
            body { padding: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body onload="window.print()">
    <div class="no-print" style="margin-bottom: 20px; text-align: right;">
        <button onclick="window.print()" style="padding: 10px 20px; background: #2473f2; color: white; border: none; border-radius: 5px; cursor: pointer; font-weight: bold;">Imprimir / Guardar PDF</button>
        <button onclick="window.close()" style="padding: 10px 20px; background: #e2e8f0; color: #333; border: none; border-radius: 5px; cursor: pointer; font-weight: bold; margin-left: 10px;">Cerrar Pestaña</button>
    </div>

    <div class="header">
        <h2>Reporte Historial de Cajas</h2>
        <p><strong>Sucursal:</strong> <?php echo $nombre_sucursal_reporte; ?> | <strong>Período:</strong> <?php echo date('d/m/Y', strtotime($f_inicio)); ?> al <?php echo date('d/m/Y', strtotime($f_fin)); ?></p>
        <p><strong>Generado por:</strong> Sistema SoundCrow - <?php echo date("d/m/Y H:i A"); ?></p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Fecha/Hora</th>
                <th>Sucursal</th>
                <th>Cajero responsable</th>
                <th class="text-right">Apertura (S/)</th>
                <th class="text-right">Ingresos (S/)</th>
                <th class="text-right">Egresos (S/)</th>
                <th class="text-right">Faltante (S/)</th>
                <th class="text-right">Saldo Final (S/)</th>
                <th class="text-center">Estado</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $tot_apertura = 0; $tot_ingresos = 0; $tot_egresos = 0; $tot_faltante = 0; $tot_cierre = 0;

            if(mysqli_num_rows($query) > 0){
                while ($row = mysqli_fetch_array($query)) {
                    $fecha_apertura = date('d/m/Y h:i A', strtotime($row['fec_reg']));
                    $tienda_nombre = !empty($row['nombre_stand']) ? $row['nombre_stand'] : $row['nombre'];
                    
                    $apertura = floatval($row['inicio']);
                    $ingresos = floatval($row['entrada']);
                    $egresos = floatval($row['salida']);
                    $faltante = floatval($row['faltante']);
                    
                    $estado_abierta = ($row['usuario_cierre'] == 0);
                    $cierre = $estado_abierta ? (($apertura + $ingresos) - $egresos - $faltante) : floatval($row['cierre']);
                    
                    $tot_apertura += $apertura; $tot_ingresos += $ingresos; $tot_egresos += $egresos; 
                    $tot_faltante += $faltante; $tot_cierre += $cierre;
                    ?>
                    <tr>
                        <td><?php echo $fecha_apertura; ?></td>
                        <td><?php echo $tienda_nombre; ?></td>
                        <td><?php echo $row['cajero']; ?></td>
                        <td class="text-right"><?php echo number_format($apertura, 2); ?></td>
                        <td class="text-right"><?php echo number_format($ingresos, 2); ?></td>
                        <td class="text-right"><?php echo number_format($egresos, 2); ?></td>
                        <td class="text-right"><?php echo number_format($faltante, 2); ?></td>
                        <td class="text-right" style="font-weight: bold;"><?php echo number_format($cierre, 2); ?></td>
                        <td class="text-center"><?php echo $estado_abierta ? 'ACTIVA' : 'CERRADA'; ?></td>
                    </tr>
                    <?php
                }
            } else {
                echo "<tr><td colspan='9' class='text-center'>No hay registros en el rango de fechas seleccionado.</td></tr>";
            }
            ?>
        </tbody>
        <?php if(mysqli_num_rows($query) > 0): ?>
        <tfoot class="tfoot">
            <tr>
                <td colspan="3" class="text-right">TOTALES GLOBALES:</td>
                <td class="text-right"><?php echo number_format($tot_apertura, 2); ?></td>
                <td class="text-right"><?php echo number_format($tot_ingresos, 2); ?></td>
                <td class="text-right"><?php echo number_format($tot_egresos, 2); ?></td>
                <td class="text-right"><?php echo number_format($tot_faltante, 2); ?></td>
                <td class="text-right"><?php echo number_format($tot_cierre, 2); ?></td>
                <td></td>
            </tr>
        </tfoot>
        <?php endif; ?>
    </table>
</body>
</html>