<?php
session_start();
if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
    header("location: login.php");
    exit;
}

require_once ("config/db.php");
require_once ("config/conexion.php");

$sql = "SELECT * FROM clientes ORDER BY nombre_cliente ASC";
$query = mysqli_query($con, $sql);

$sql_empresa = "SELECT * FROM datosempresa WHERE id_emp=1";
$query_empresa = mysqli_query($con, $sql_empresa);
$row_empresa = mysqli_fetch_array($query_empresa);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Reporte de Clientes | SoundCrow</title>
    <style>
        body { font-family: 'Helvetica', 'Arial', sans-serif; font-size: 11px; color: #333; }
        .header { width: 100%; border-bottom: 2px solid #0a2463; padding-bottom: 10px; margin-bottom: 20px; }
        .logo { max-width: 150px; max-height: 60px; }
        .empresa-info { text-align: right; float: right; }
        
        h1 { color: #0a2463; font-size: 18px; text-transform: uppercase; margin: 0; }
        
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th { background-color: #0a2463; color: white; padding: 6px; text-align: left; font-size: 11px; }
        td { border-bottom: 1px solid #ddd; padding: 6px; font-size: 11px; }
        tr:nth-child(even) { background-color: #f2f2f2; }
        
        @media print { .no-print { display: none; } }
    </style>
</head>
<body>

    <div class="no-print" style="text-align:right; padding: 10px; background: #eee; border-bottom: 1px solid #ccc;">
        <button onclick="window.print();" style="cursor:pointer; font-weight:bold; padding:8px 15px; background:#0a2463; color:white; border:none; border-radius: 4px;">
            🖨️ Imprimir / Guardar PDF
        </button>
    </div>

    <div class="header">
        <div class="empresa-info">
            <strong><?php echo $row_empresa['nom_emp']; ?></strong><br>
            <?php echo $row_empresa['dir_emp']; ?><br>
            Tel: <?php echo $row_empresa['tel_emp']; ?>
        </div>
        <img src="logo.png" class="logo" alt="Logo"> 
        <div style="clear:both;"></div>
    </div>

    <center><h1>Listado General de Clientes</h1></center>
    <p><strong>Fecha:</strong> <?php echo date("d/m/Y H:i:s"); ?></p>

    <table>
        <thead>
            <tr>
                <th style="width: 5%;">NRO</th>
                <th style="width: 15%;">Documento</th>
                <th style="width: 25%;">Nombre</th>
                <th style="width: 30%;">Dirección</th>
                <th style="width: 15%;">Teléfono</th>
                <th style="width: 10%;">Fecha</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $item = 0;
            while ($row = mysqli_fetch_array($query)) {
                $item++;
                
                // --- LÓGICA INTELIGENTE (Igual que en Excel) ---
                $doc = "";
                if(!empty($row['documento_cliente'])) { $doc = $row['documento_cliente']; }
                elseif(!empty($row['documento'])) { $doc = $row['documento']; }
                elseif(!empty($row['dni'])) { $doc = $row['dni']; }
                elseif(!empty($row['ruc'])) { $doc = $row['ruc']; }
                elseif(!empty($row['numero_documento'])) { $doc = $row['numero_documento']; }
                // ----------------------------------------------
            ?>
            <tr>
                <td><?php echo $item; ?></td>
                <td><?php echo $doc; ?></td>
                <td><?php echo $row['nombre_cliente']; ?></td>
                <td><?php echo $row['direccion_cliente']; ?></td>
                <td><?php echo $row['telefono_cliente']; ?></td>
                <td><?php echo date("d/m/Y", strtotime($row['date_added'])); ?></td>
            </tr>
            <?php } ?>
        </tbody>
    </table>

    <script>
        window.onload = function() { window.print(); }
    </script>
</body>
</html>