<?php
session_start();
if (!isset($_SESSION['user_login_status']) || $_SESSION['user_login_status'] != 1) { 
    header("location: login.php"); 
    exit; 
}

require_once ("config/db.php");
require_once ("config/conexion.php");

// Seguridad
$user_id_actual = $_SESSION['user_id'];
$sql_rol = mysqli_query($con, "SELECT rol FROM users WHERE user_id = '$user_id_actual'");
$rw_rol = mysqli_fetch_array($sql_rol);
$rol_actual = isset($rw_rol['rol']) ? intval($rw_rol['rol']) : 1;

if ($rol_actual !== 2) {
    header("location: resumen.php");
    exit;
}

include('menu.php');
$mes_actual = date("m");
$anio_actual = date("Y");


   $sql1="select * from users where user_id=$_SESSION[user_id]";
    $rw1=mysqli_query($con,$sql1);
    $rs1=mysqli_fetch_array($rw1);
    $modulo=$rs1["accesos"];
    $a = explode(".", $modulo); 
    
    if($a[29]==0){ header("location:error.php"); }




?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Reporte Contable SUNAT | SoundCrow</title>
    
    <link rel="icon" href="logo.ico">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        body { font-family: 'Poppins', sans-serif !important; background-color: #F0F2F5; color: #334155; }
        .sc-card { background: #ffffff; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); border: none; overflow: hidden; margin-bottom: 30px; }
        .sc-header { background: linear-gradient(90deg, #0a2463 0%, #2473f2 100%); padding: 20px 30px; color: white; display: flex; align-items: center; justify-content: space-between; }
        .sc-title { margin: 0; font-size: 18px; font-weight: 700; text-transform: uppercase; letter-spacing: 0.5px; color: white; }
        .sc-body { padding: 30px; }
        
        .form-control-sc { border-radius: 8px; border: 1px solid #e2e8f0; padding: 10px 15px; height: 45px; background-color: #f8fafc; width: 100%; transition: 0.3s; color: #334155; font-weight: 500; }
        .form-control-sc:focus { background-color: #fff; border-color: #2473f2; box-shadow: 0 0 0 3px rgba(36, 115, 242, 0.1); outline: none; }
        .form-label-sc { font-weight: 600; color: #64748b; font-size: 12px; text-transform: uppercase; margin-bottom: 8px; display: block; }

        .btn-excel { background: #10b981; color: white; border-radius: 8px; padding: 12px 20px; border: none; font-weight: 700; height: 50px; width: 100%; box-shadow: 0 4px 10px rgba(16, 185, 129, 0.3); transition: all 0.3s; }
        .btn-excel:hover { background: #059669; transform: translateY(-2px); color: white; }
        
        .btn-pdf { background: #ef4444; color: white; border-radius: 8px; padding: 12px 20px; border: none; font-weight: 700; height: 50px; width: 100%; box-shadow: 0 4px 10px rgba(239, 68, 68, 0.3); transition: all 0.3s; }
        .btn-pdf:hover { background: #dc2626; transform: translateY(-2px); color: white; }
    </style>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col">
                <div class="left_col scroll-view">
                    <div class="clearfix"></div>
                    <?php menu2(); menu1(); ?>
                </div>
            </div>
            <?php menu3(); ?>

            <div class="right_col" role="main" style="background-color: #F0F2F5;">
                <div class="row">
                    <div class="col-md-10 col-md-offset-1" style="padding-top: 30px;">
                        
                        <div class="sc-card">
                            <div class="sc-header">
                                <h3 class="sc-title"><i class="fa fa-book"></i> Reporte Contable Mensual (SUNAT)</h3>
                            </div>
                            
                            <div class="sc-body">
                                <div class="alert alert-info" style="background: #e0f2fe; border: 1px solid #bae6fd; color: #0369a1; border-radius: 8px; padding: 15px;">
                                    <i class="fa fa-info-circle"></i> Este módulo filtra <strong>únicamente Facturas y Boletas Electrónicas</strong> válidas emitidas en el mes seleccionado. Omite tickets y notas internas.
                                </div>

                                <div class="row" style="margin-top: 25px;">
                                    <div class="col-md-4 col-sm-4" style="margin-bottom: 15px;">
                                        <label class="form-label-sc">Mes</label>
                                        <select class="form-control-sc" id="mes_reporte">
                                            <option value="01" <?php if($mes_actual=='01') echo 'selected'; ?>>Enero</option>
                                            <option value="02" <?php if($mes_actual=='02') echo 'selected'; ?>>Febrero</option>
                                            <option value="03" <?php if($mes_actual=='03') echo 'selected'; ?>>Marzo</option>
                                            <option value="04" <?php if($mes_actual=='04') echo 'selected'; ?>>Abril</option>
                                            <option value="05" <?php if($mes_actual=='05') echo 'selected'; ?>>Mayo</option>
                                            <option value="06" <?php if($mes_actual=='06') echo 'selected'; ?>>Junio</option>
                                            <option value="07" <?php if($mes_actual=='07') echo 'selected'; ?>>Julio</option>
                                            <option value="08" <?php if($mes_actual=='08') echo 'selected'; ?>>Agosto</option>
                                            <option value="09" <?php if($mes_actual=='09') echo 'selected'; ?>>Septiembre</option>
                                            <option value="10" <?php if($mes_actual=='10') echo 'selected'; ?>>Octubre</option>
                                            <option value="11" <?php if($mes_actual=='11') echo 'selected'; ?>>Noviembre</option>
                                            <option value="12" <?php if($mes_actual=='12') echo 'selected'; ?>>Diciembre</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4 col-sm-4" style="margin-bottom: 15px;">
                                        <label class="form-label-sc">Año</label>
                                        <select class="form-control-sc" id="anio_reporte">
                                            <?php
                                            for($i = 2023; $i <= date("Y"); $i++) {
                                                $selected = ($i == $anio_actual) ? "selected" : "";
                                                echo "<option value='$i' $selected>$i</option>";
                                            }
                                            ?>
                                        </select>
                                    </div>
                                    <div class="col-md-4 col-sm-4" style="margin-bottom: 15px;">
                                        <label class="form-label-sc">Sucursal / Tienda</label>
                                        <select class="form-control-sc" id="id_sucursal">
                                            <?php if($rol_actual == 2): ?>
                                                <option value="todas">Todas las Sucursales</option>
                                            <?php endif; ?>
                                            <?php
                                            $filtro_tienda = ($rol_actual == 2) ? "WHERE tipo_sucursal=1" : "WHERE id_sucursal='".$_SESSION['tienda']."' AND tipo_sucursal=1";
                                            $q_tiendas = mysqli_query($con, "SELECT id_sucursal, nombre_stand, nombre FROM sucursal $filtro_tienda");
                                            while ($rw = mysqli_fetch_array($q_tiendas)) {
                                                $nombre_s = !empty($rw['nombre_stand']) ? $rw['nombre_stand'] : $rw['nombre'];
                                                echo "<option value='".$rw['id_sucursal']."'>$nombre_s</option>";
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>

                                <hr style="border-top: 1px dashed #e2e8f0; margin: 30px 0;">

                                <div class="row">
                                    <div class="col-md-6 col-sm-6" style="margin-bottom: 10px;">
                                        <button type="button" class="btn-excel" onclick="generarExcel()">
                                            <i class="fa fa-file-excel-o" style="font-size: 16px; margin-right: 5px;"></i> Descargar en Excel
                                        </button>
                                    </div>
                                    <div class="col-md-6 col-sm-6">
                                        <button type="button" class="btn-pdf" onclick="generarPDF()">
                                            <i class="fa fa-file-pdf-o" style="font-size: 16px; margin-right: 5px;"></i> Ver en Pantalla / Imprimir PDF
                                        </button>
                                    </div>
                                </div>
                                
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <?php footer(); ?>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/custom.js"></script>

    <script>
        // Funciones actualizadas enviando la sucursal por GET
        function generarExcel() {
            var mes = $("#mes_reporte").val();
            var anio = $("#anio_reporte").val();
            var sucursal = $("#id_sucursal").val();
            window.location.href = "reporte_sunat_excel.php?mes=" + mes + "&anio=" + anio + "&sucursal=" + sucursal;
        }

        function generarPDF() {
            var mes = $("#mes_reporte").val();
            var anio = $("#anio_reporte").val();
            var sucursal = $("#id_sucursal").val();
            window.open("reporte_sunat_pdf.php?mes=" + mes + "&anio=" + anio + "&sucursal=" + sucursal, "_blank");
        }
    </script>
</body>
</html>