<?php
session_start();
include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

// Verificación de sesión
if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) { header("location: login.php"); exit; }

$sql1="select * from users where user_id='".$_SESSION['user_id']."'";
$rw1=mysqli_query($con,$sql1);
$rs1=mysqli_fetch_array($rw1);
$modulo=$rs1["accesos"];
$a = explode(".", $modulo); 

// Usamos el mismo permiso que compras (índice 6) o el que consideres para reportes
if($a[14]==0){ header("location:error.php"); exit; }
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Reporte de Pagos a Proveedores | SoundCrow</title>
    
    <link rel="icon" href="logo.ico">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        body { font-family: 'Poppins', sans-serif !important; background-color: #F0F2F5; color: #334155; }
        
        .sc-card { background: #ffffff; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); border: none; overflow: hidden; margin-bottom: 30px; }
        .sc-header { background: linear-gradient(90deg, #0a2463 0%, #2473f2 100%); padding: 20px 30px; color: white; display: flex; align-items: center; justify-content: space-between; }
        .sc-title { margin: 0; font-size: 18px; font-weight: 700; text-transform: uppercase; color: white; }
        .sc-body { padding: 30px; }

        /* Estilos de Filtros */
        .form-control-sc { border-radius: 8px; border: 1px solid #e2e8f0; padding: 0 10px; height: 40px; background-color: #f8fafc; width: 100%; color: #334155; font-weight:500; font-size: 13px; }
        .form-control-sc:focus { background-color: #fff; border-color: #2473f2; outline: none; }
        .label-filter { font-size: 11px; font-weight: 700; text-transform: uppercase; color: #64748b; margin-bottom: 5px; display:block; }
        
        .btn-search { background: #2473f2; color: white; border: none; border-radius: 8px; height: 40px; width: 100%; font-weight: 600; transition: 0.3s; margin-top: 24px; }
        .btn-search:hover { background: #1a5cbf; }
        
        /* Badges para métodos de pago */
        .badge-pago { padding: 5px 10px; border-radius: 20px; font-size: 11px; font-weight: 600; }
        .bg-efectivo { background: #dcfce7; color: #166534; }
        .bg-banco { background: #dbeafe; color: #1e40af; }
        .bg-app { background: #fce7f3; color: #9d174d; } /* Yape/Plin */
        .bg-tarjeta { background: #ffedd5; color: #9a3412; }
    </style>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col"><div class="left_col scroll-view"><div class="clearfix"></div><?php menu2(); menu1(); ?></div></div>
            <?php menu3(); ?>

            <div class="right_col" role="main">
                
                <div class="row">
                    <div class="col-md-12" style="padding-top:15px">
                        <div class="sc-card">
                            <div class="sc-header">
                                <h3 class="sc-title"><i class="fa fa-money"></i> Historial de Pagos (Egresos)</h3>
                            </div>
                            
                            <div class="sc-body">
                                <form class="form-horizontal" onsubmit="return false;">
                                    <div class="row">
                                        <div class="col-md-3 form-group">
                                            <span class="label-filter">Buscar (Proveedor / N° Doc)</span>
                                            <input type="text" class="form-control-sc" id="q" placeholder="Escribe para buscar..." onkeyup='load(1);'>
                                        </div>
                                        
                                        <div class="col-md-2 form-group">
                                            <span class="label-filter">Fecha Inicio</span>
                                            <input type="date" class="form-control-sc" id="fecha_ini" value="<?php echo date('Y-m-01'); ?>" onchange="load(1);">
                                        </div>
                                        <div class="col-md-2 form-group">
                                            <span class="label-filter">Fecha Fin</span>
                                            <input type="date" class="form-control-sc" id="fecha_fin" value="<?php echo date('Y-m-d'); ?>" onchange="load(1);">
                                        </div>

                                        <div class="col-md-2 form-group">
                                            <span class="label-filter">Medio de Pago</span>
                                            <select class="form-control-sc" id="forma_pago" onchange="load(1);">
                                                <option value="">Todos</option>
                                                <option value="1">Efectivo</option>
                                                <option value="2">Transferencia</option>
                                                <option value="3">Yape / Plin</option>
                                                <option value="4">Tarjeta</option>
                                            </select>
                                        </div>

                                        <div class="col-md-2 form-group">
                                            <span class="label-filter">Sucursal</span>
                                            <select class="form-control-sc" id="tienda" onchange="load(1);">
                                                <option value="">Todas</option>
                                                <?php
                                                $sql_s = "SELECT * FROM sucursal ORDER BY tienda ASC";
                                                $res_s = mysqli_query($con, $sql_s);
                                                while($row_s=mysqli_fetch_array($res_s)){
                                                    $nom_t = !empty($row_s['nombre_stand']) ? $row_s['nombre_stand'] : $row_s['nombre'];
                                                    echo "<option value='".$row_s['tienda']."'>$nom_t</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>

                                        <div class="col-md-1 form-group">
                                            <button type="button" class="btn-search" onclick="load(1);"><i class="fa fa-search"></i></button>
                                        </div>
                                    </div>
                                </form>
                                
                                <div id="loader" style="text-align: center; display:none; margin: 20px;"><img src="./img/ajax-loader.gif"></div>
                                <div class="outer_div"></div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/custom.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    
    <script>
        $(document).ready(function(){
            load(1);
        });

        function load(page){
            var q = $("#q").val();
            var fecha_ini = $("#fecha_ini").val();
            var fecha_fin = $("#fecha_fin").val();
            var forma_pago = $("#forma_pago").val();
            var tienda = $("#tienda").val();
            
            $("#loader").fadeIn('slow');
            $.ajax({
                url:'./ajax/buscar_pagos_compras.php?action=ajax&page='+page+'&q='+q+'&fecha_ini='+fecha_ini+'&fecha_fin='+fecha_fin+'&forma_pago='+forma_pago+'&tienda='+tienda,
                beforeSend: function(objeto){
                    $('#loader').html('<img src="./img/ajax-loader.gif"> Cargando...');
                },
                success:function(data){
                    $(".outer_div").html(data).fadeIn('slow');
                    $('#loader').html('');
                }
            })
        }
    </script>
</body>
</html>