<?php
session_start();
if (!isset($_SESSION['user_login_status']) || $_SESSION['user_login_status'] != 1) { exit; }

require_once ("config/db.php");
require_once ("config/conexion.php");

$mes = mysqli_real_escape_string($con, strip_tags($_GET['mes'], ENT_QUOTES));
$anio = mysqli_real_escape_string($con, strip_tags($_GET['anio'], ENT_QUOTES));
$sucursal = mysqli_real_escape_string($con, strip_tags($_GET['sucursal'], ENT_QUOTES));

// Consulta simplificada y segura usando el valor numérico 1 y 2 (según la tabla documento)
$sWhere = "WHERE MONTH(f.fecha_factura) = '$mes' AND YEAR(f.fecha_factura) = '$anio' 
           AND f.ven_com = 1 AND f.estado_factura IN (1, 2)";

$nombre_sucursal_reporte = "TODAS LAS SUCURSALES";

if ($sucursal != 'todas') {
    $sWhere .= " AND f.tienda = '$sucursal'";
    $q_s = mysqli_query($con, "SELECT nombre_stand, nombre FROM sucursal WHERE id_sucursal='$sucursal'");
    if($r_s = mysqli_fetch_array($q_s)){
        $nombre_sucursal_reporte = !empty($r_s['nombre_stand']) ? $r_s['nombre_stand'] : $r_s['nombre'];
    }
}

header("Content-Type: application/vnd.ms-excel; charset=UTF-8");
header("Content-Disposition: attachment; filename=Reporte_SUNAT_Ventas_{$mes}_{$anio}.xls");
header("Pragma: no-cache");
header("Expires: 0");

echo "\xEF\xBB\xBF"; 

// Consulta directa sin JOIN a la tabla documento (para evitar problemas de tipos de datos)
$sql = "SELECT f.fecha_factura, f.numero_factura, f.folio, f.aceptado, f.estado_factura, c.documento, c.nombre_cliente, f.total_venta 
        FROM facturas f 
        INNER JOIN clientes c ON f.id_cliente = c.id_cliente 
        $sWhere 
        ORDER BY f.fecha_factura ASC, f.numero_factura ASC";

$query = mysqli_query($con, $sql);
?>
<table border="1" cellpadding="5" cellspacing="0">
    <thead>
        <tr>
            <th colspan="12" style="font-size:16px; text-align:center; background:#f1f5f9;">REPORTE MENSUAL SUNAT - <?php echo $nombre_sucursal_reporte; ?> (<?php echo $mes."/".$anio; ?>)</th>
        </tr>
        <tr style="background-color: #0a2463; color: white;">
            <th>Nro.</th>
            <th>FECHA EMISIÓN</th>
            <th>TIPO DOC.</th>
            <th>SERIE - CORRELATIVO</th>
            <th>TIPO DOC IDENTIDAD</th>
            <th>RUC / DNI CLIENTE</th>
            <th>RAZON SOCIAL / NOMBRE</th>
            <th>MONEDA</th>
            <th>BASE IMPONIBLE (GRAVADA)</th>
            <th>IGV (18%)</th>
            <th>IMPORTE TOTAL</th>
            <th>ESTADO SUNAT</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $n = 1; $suma_base = 0; $suma_igv = 0; $suma_total = 0;

        while ($row = mysqli_fetch_array($query)) {
            $fecha = date("d/m/Y", strtotime($row['fecha_factura']));
            $nro_doc = $row['folio'] . '-' . $row['numero_factura'];
            
            // Asignamos el nombre basándonos en el campo estado_factura
            $tipo_sunat = ($row['estado_factura'] == 1) ? '01 - FACTURA' : '03 - BOLETA';
            
            $doc_cliente = $row['documento'];
            $tipo_id_cliente = (strlen(trim($doc_cliente)) == 11) ? '6 - RUC' : '1 - DNI';
            
            $estado_sunat = !empty($row['aceptado']) ? $row['aceptado'] : 'Pendiente';

            $total = floatval($row['total_venta']);
            $base_imponible = $total / 1.18;
            $igv = $total - $base_imponible;

            $suma_base += $base_imponible; $suma_igv += $igv; $suma_total += $total;
            ?>
            <tr>
                <td><?php echo $n++; ?></td>
                <td><?php echo $fecha; ?></td>
                <td><?php echo $tipo_sunat; ?></td>
                <td><?php echo $nro_doc; ?></td>
                <td><?php echo $tipo_id_cliente; ?></td>
                <td><?php echo $doc_cliente; ?></td>
                <td><?php echo htmlspecialchars($row['nombre_cliente']); ?></td>
                <td>PEN</td>
                <td><?php echo number_format($base_imponible, 2, '.', ''); ?></td>
                <td><?php echo number_format($igv, 2, '.', ''); ?></td>
                <td><?php echo number_format($total, 2, '.', ''); ?></td>
                <td style="font-weight: bold; <?php echo ($estado_sunat == 'Pendiente') ? 'color: #d97706;' : 'color: #059669;'; ?>"><?php echo strtoupper($estado_sunat); ?></td>
            </tr>
            <?php } ?>
    </tbody>
    <tfoot>
        <tr style="font-weight: bold; background-color: #f1f5f9;">
            <td colspan="8" align="right">TOTAL MENSUAL PEN:</td>
            <td><?php echo number_format($suma_base, 2, '.', ''); ?></td>
            <td><?php echo number_format($suma_igv, 2, '.', ''); ?></td>
            <td><?php echo number_format($suma_total, 2, '.', ''); ?></td>
            <td></td>
        </tr>
    </tfoot>
</table>