<?php
session_start();
if (!isset($_SESSION['user_login_status']) || $_SESSION['user_login_status'] != 1) { exit; }

require_once ("config/db.php");
require_once ("config/conexion.php");

$mes = mysqli_real_escape_string($con, strip_tags($_GET['mes'], ENT_QUOTES));
$anio = mysqli_real_escape_string($con, strip_tags($_GET['anio'], ENT_QUOTES));
$sucursal = mysqli_real_escape_string($con, strip_tags($_GET['sucursal'], ENT_QUOTES));

$meses_letras = ["01"=>"ENERO","02"=>"FEBRERO","03"=>"MARZO","04"=>"ABRIL","05"=>"MAYO","06"=>"JUNIO","07"=>"JULIO","08"=>"AGOSTO","09"=>"SEPTIEMBRE","10"=>"OCTUBRE","11"=>"NOVIEMBRE","12"=>"DICIEMBRE"];

$sWhere = "WHERE MONTH(f.fecha_factura) = '$mes' AND YEAR(f.fecha_factura) = '$anio' 
           AND f.ven_com = 1 AND f.estado_factura IN (1, 2)";

$nombre_sucursal_reporte = "TODAS LAS SUCURSALES";

if ($sucursal != 'todas') {
    $sWhere .= " AND f.tienda = '$sucursal'";
    $q_s = mysqli_query($con, "SELECT nombre_stand, nombre FROM sucursal WHERE id_sucursal='$sucursal'");
    if($r_s = mysqli_fetch_array($q_s)){
        $nombre_sucursal_reporte = !empty($r_s['nombre_stand']) ? $r_s['nombre_stand'] : $r_s['nombre'];
    }
}

$sql = "SELECT f.fecha_factura, f.numero_factura, f.folio, f.aceptado, f.estado_factura, c.documento, c.nombre_cliente, f.total_venta 
        FROM facturas f 
        INNER JOIN clientes c ON f.id_cliente = c.id_cliente 
        $sWhere 
        ORDER BY f.fecha_factura ASC, f.numero_factura ASC";

$query = mysqli_query($con, $sql);

if (!$query) { die("Error SQL: " . mysqli_error($con)); }
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>Reporte Mensual SUNAT</title>
    <style>
        body { font-family: 'Arial', sans-serif; color: #111; font-size: 11px; padding: 20px; }
        .header { text-align: center; margin-bottom: 20px; border-bottom: 2px solid #000; padding-bottom: 10px; }
        .header h2 { margin: 0; font-size: 18px; text-transform: uppercase; }
        .header p { margin: 5px 0 0 0; font-size: 13px; color: #444;}
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #444; padding: 6px; text-align: left; }
        th { background-color: #eee; text-align: center; }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
        .tfoot td { background-color: #eee; font-weight: bold; font-size: 12px; }
        .estado-ok { color: #059669; font-weight: bold; }
        .estado-pend { color: #d97706; font-weight: bold; }
        @media print {
            @page { margin: 1cm; size: landscape; }
            body { padding: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body onload="window.print()">
    
    <div class="no-print" style="margin-bottom: 20px; text-align: right;">
        <button onclick="window.print()" style="padding: 10px 20px; background: #ef4444; color: white; border: none; font-weight: bold; cursor: pointer; border-radius: 5px;">Imprimir / Guardar PDF</button>
        <button onclick="window.close()" style="padding: 10px 20px; margin-left: 10px; cursor: pointer; border-radius: 5px;">Cerrar</button>
    </div>

    <div class="header">
        <h2>REPORTE MENSUAL DE COMPROBANTES DE PAGO ELECTRÓNICOS (SUNAT)</h2>
        <p>SUCURSAL: <strong><?php echo $nombre_sucursal_reporte; ?></strong> | PERÍODO: <strong><?php echo $meses_letras[$mes]." - ".$anio; ?></strong></p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Nº</th>
                <th>FECHA</th>
                <th>TIPO</th>
                <th>SERIE Y CORRELATIVO</th>
                <th>TIPO DOC</th>
                <th>Nº DOCUMENTO</th>
                <th>RAZÓN SOCIAL / CLIENTE</th>
                <th>MON.</th>
                <th class="text-right">BASE IMP. (S/)</th>
                <th class="text-right">IGV 18% (S/)</th>
                <th class="text-right">TOTAL (S/)</th>
                <th>ESTADO SUNAT</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $n = 1; $suma_base = 0; $suma_igv = 0; $suma_total = 0;

            if(mysqli_num_rows($query) > 0){
                while ($row = mysqli_fetch_array($query)) {
                    $fecha = date("d/m/Y", strtotime($row['fecha_factura']));
                    $nro_doc = $row['folio'] . '-' . $row['numero_factura'];
                    
                    // Asignamos el nombre basándonos en el campo estado_factura
                    $tipo_sunat = ($row['estado_factura'] == 1) ? 'FACTURA' : 'BOLETA';
                    
                    $doc_cliente = $row['documento'];
                    $tipo_id_cliente = (strlen(trim($doc_cliente)) == 11) ? 'RUC' : 'DNI';
                    
                    $estado_sunat = !empty($row['aceptado']) ? $row['aceptado'] : 'Pendiente';
                    $clase_estado = ($estado_sunat == 'Pendiente') ? 'estado-pend' : 'estado-ok';

                    $total = floatval($row['total_venta']);
                    $base_imponible = $total / 1.18;
                    $igv = $total - $base_imponible;

                    $suma_base += $base_imponible; $suma_igv += $igv; $suma_total += $total;
                    ?>
                    <tr>
                        <td class="text-center"><?php echo $n++; ?></td>
                        <td class="text-center"><?php echo $fecha; ?></td>
                        <td class="text-center"><?php echo $tipo_sunat; ?></td>
                        <td class="text-center" style="font-weight: bold;"><?php echo $nro_doc; ?></td>
                        <td class="text-center"><?php echo $tipo_id_cliente; ?></td>
                        <td class="text-center"><?php echo $doc_cliente; ?></td>
                        <td><?php echo htmlspecialchars($row['nombre_cliente']); ?></td>
                        <td class="text-center">PEN</td>
                        <td class="text-right"><?php echo number_format($base_imponible, 2); ?></td>
                        <td class="text-right"><?php echo number_format($igv, 2); ?></td>
                        <td class="text-right" style="font-weight: bold;"><?php echo number_format($total, 2); ?></td>
                        <td class="text-center <?php echo $clase_estado; ?>"><?php echo strtoupper($estado_sunat); ?></td>
                    </tr>
                    <?php
                }
            } else {
                echo "<tr><td colspan='12' class='text-center'>No se encontraron comprobantes electrónicos en este período.</td></tr>";
            }
            ?>
        </tbody>
        <?php if(mysqli_num_rows($query) > 0): ?>
        <tfoot class="tfoot">
            <tr>
                <td colspan="8" class="text-right">TOTAL DECLARADO DEL MES:</td>
                <td class="text-right"><?php echo number_format($suma_base, 2); ?></td>
                <td class="text-right"><?php echo number_format($suma_igv, 2); ?></td>
                <td class="text-right"><?php echo number_format($suma_total, 2); ?></td>
                <td></td>
            </tr>
        </tfoot>
        <?php endif; ?>
    </table>
</body>
</html>