<?php
session_start();

// Validar que esté logueado
if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
    header("location: login.php");
    exit;
}

require_once ("config/db.php");
require_once ("config/conexion.php");

$user_id = $_SESSION['user_id'];
$tienda_id = $_SESSION['tienda'];

// 1. OBTENER EL ROL REAL DESDE LA BASE DE DATOS
$sql_user = mysqli_query($con, "SELECT rol FROM users WHERE user_id = '$user_id'");
$rw_user = mysqli_fetch_array($sql_user);
$rol = isset($rw_user['rol']) ? intval($rw_user['rol']) : 1;

// 2. OBTENER EL TIPO DE SUCURSAL DESDE LA BASE DE DATOS
$sql_sucursal = mysqli_query($con, "SELECT tipo_sucursal FROM sucursal WHERE id_sucursal = '$tienda_id'");
$rw_sucursal = mysqli_fetch_array($sql_sucursal);
$tipo_sucursal = isset($rw_sucursal['tipo_sucursal']) ? intval($rw_sucursal['tipo_sucursal']) : 1;

// 3. LÓGICA DE REDIRECCIÓN ESTRICTA
if ($rol === 2) {
    // Si es Administrador -> Control Global
    header("Location: resumen_ac.php");
    exit;
} else if ($rol === 3) {
    // Si no es admin y está en un Almacén -> Resumen Almacén
    header("Location: resumen_al.php");
    exit;
} else if ($tipo_sucursal === 2 ) {
    // Si no es admin y está en un Almacén -> Resumen Almacén
    header("Location: resumen_al.php");
    exit;
} else {
    // Si no es admin y está en una Tienda -> Resumen Tienda (Vendedor)
    header("Location: resumen_t.php");
    exit;
}
?>