<?php
/**
 * RESUMEN_AC.PHP - DASHBOARD PARA ADMINISTRADORES
 * Control Global, Monitor de Cajas por Sucursal y Gráficos de Ventas.
 */
session_start();

// 1. SEGURIDAD DE SESIÓN BÁSICA
if (!isset($_SESSION['user_login_status']) || $_SESSION['user_login_status'] != 1) { 
    header("location: login.php"); 
    exit; 
}

require_once ("config/db.php");
require_once ("config/conexion.php");

// =========================================================================
// 2. CANDADO ESTRICTO DE ROL (SOLO ADMINISTRADOR)
// =========================================================================
$user_id_actual = $_SESSION['user_id'];
$sql_rol = mysqli_query($con, "SELECT rol FROM users WHERE user_id = '$user_id_actual'");
$rw_rol = mysqli_fetch_array($sql_rol);
$rol_actual = isset($rw_rol['rol']) ? intval($rw_rol['rol']) : 1;

if ($rol_actual !== 2) {
    // Si intenta entrar alguien que NO es administrador, lo pateamos al enrutador
    // El enrutador (resumen.php) se encargará de mandarlo a su tienda o almacén
    header("location: resumen.php");
    exit;
}
// =========================================================================

include('menu.php');

date_default_timezone_set('America/Lima');
$fecha_hoy = date("Y-m-d");

// Total Ventas Globales (Hoy)
$q_ventas_hoy = mysqli_query($con, "SELECT SUM(total_venta) as t FROM facturas WHERE DATE(fecha_factura) = '$fecha_hoy' AND ven_com = 1 AND estado_factura <> 32");
$total_ventas_global = ($q_ventas_hoy && $r = mysqli_fetch_array($q_ventas_hoy)) ? floatval($r['t']) : 0;

// Obtener TODAS las Tiendas (tipo_sucursal = 1)
$q_tiendas = mysqli_query($con, "SELECT id_sucursal, nombre_stand, nombre FROM sucursal WHERE tipo_sucursal = 1 ORDER BY id_sucursal ASC");

$tiendas_data = [];
$cajas_abiertas_count = 0;
$total_tiendas_count = 0;
$grafico_ventas = []; // Para el gráfico de Morris

while ($t = mysqli_fetch_array($q_tiendas)) {
    $total_tiendas_count++;
    $id_tienda = $t['id_sucursal'];
    $nombre_tienda = (!empty($t['nombre_stand'])) ? $t['nombre_stand'] : $t['nombre'];
    
    // Verificar si esta tienda tiene la caja abierta
    $q_caja = mysqli_query($con, "SELECT c.inicio, c.fec_reg, u.nombres FROM caja c INNER JOIN users u ON c.usuario_inicio = u.user_id WHERE c.tienda = '$id_tienda' AND c.usuario_cierre = 0 LIMIT 1");
    $caja = mysqli_fetch_array($q_caja);
    
    $estado_caja = false;
    $ventas_turno = 0;
    
    if ($caja) {
        $estado_caja = true;
        $cajas_abiertas_count++;
        $inicio_turno = $caja['fec_reg'];
        
        // Ventas desde que abrió la caja
        $q_v = mysqli_query($con, "SELECT SUM(total_venta) as t FROM facturas WHERE tienda='$id_tienda' AND ven_com=1 AND estado_factura<>32 AND fecha_factura >= '$inicio_turno'");
        $ventas_turno = ($q_v && $r = mysqli_fetch_array($q_v)) ? floatval($r['t']) : 0;
        
        $tiendas_data[] = [
            'nombre' => $nombre_tienda,
            'abierta' => true,
            'apertura' => floatval($caja['inicio']),
            'usuario' => $caja['nombres'],
            'hora' => date('h:i A', strtotime($inicio_turno)),
            'ventas' => $ventas_turno
        ];
    } else {
        // Si está cerrada, solo calculamos las ventas de hoy (si las hubo antes de cerrar)
        $q_v = mysqli_query($con, "SELECT SUM(total_venta) as t FROM facturas WHERE tienda='$id_tienda' AND ven_com=1 AND estado_factura<>32 AND DATE(fecha_factura) = '$fecha_hoy'");
        $ventas_turno = ($q_v && $r = mysqli_fetch_array($q_v)) ? floatval($r['t']) : 0;
        
        $tiendas_data[] = [
            'nombre' => $nombre_tienda,
            'abierta' => false,
            'ventas' => $ventas_turno
        ];
    }
    
    // Preparar datos para el gráfico de barras comparativo
    $nombre_corto = (strlen($nombre_tienda) > 15) ? substr($nombre_tienda, 0, 12) . '...' : $nombre_tienda;
    $grafico_ventas[] = "{ y: '" . addslashes($nombre_corto) . "', a: " . $ventas_turno . " }";
}

$grafico_ventas_js = implode(",\n", $grafico_ventas);

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>Panel Administrativo | SoundCrow</title>
    <link rel="icon" href="logo.ico">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.css">
    
    <style>
        /* ANIMACIONES Y ESTILOS BASE */
        @keyframes fadeInUp { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }
        .animated-box { animation: fadeInUp 0.6s ease-out forwards; opacity: 0; }
        .delay-1 { animation-delay: 0.1s; } .delay-2 { animation-delay: 0.2s; } .delay-3 { animation-delay: 0.3s; }

        /* TARJETAS GLOBALES */
        .global-card { padding: 25px 20px; border-radius: 15px; color: white; margin-bottom: 25px; box-shadow: 0 8px 20px rgba(0, 0, 0, 0.08); display: flex; align-items: center; justify-content: space-between; position: relative; overflow: hidden; }
        .global-card::after { content: ''; position: absolute; top: 0; right: 0; bottom: 0; width: 40%; background: linear-gradient(90deg, transparent, rgba(255,255,255,0.1)); transform: skewX(-20deg) translateX(30%); }
        .global-icon { font-size: 50px; opacity: 0.3; }
        .bg-gradient-blue { background: linear-gradient(135deg, #2473f2, #0a2463); }
        .bg-gradient-green { background: linear-gradient(135deg, #10b981, #047857); }
        .bg-gradient-purple { background: linear-gradient(135deg, #8b5cf6, #4c1d95); }

        /* TARJETAS DE SUCURSAL (MONITOR) */
        .store-card { background: white; border-radius: 15px; border: 1px solid #e2e8f0; margin-bottom: 25px; box-shadow: 0 4px 15px rgba(0,0,0,0.03); transition: transform 0.3s ease; overflow: hidden; }
        .store-card:hover { transform: translateY(-5px); box-shadow: 0 12px 25px rgba(0,0,0,0.1); }
        
        .store-header { padding: 15px 20px; display: flex; justify-content: space-between; align-items: center; color: white; }
        .header-open { background: linear-gradient(90deg, #10b981 0%, #059669 100%); }
        .header-closed { background: linear-gradient(90deg, #ef4444 0%, #b91c1c 100%); }
        
        .store-body { padding: 20px; }
        .store-metric { display: flex; justify-content: space-between; margin-bottom: 10px; border-bottom: 1px dashed #f1f5f9; padding-bottom: 8px; }
        .store-metric:last-child { border-bottom: none; margin-bottom: 0; padding-bottom: 0; }
        .metric-label { color: #64748b; font-size: 12px; font-weight: 700; text-transform: uppercase; }
        .metric-value { color: #1e293b; font-size: 14px; font-weight: 800; }
        .val-sales { color: #2473f2; font-size: 18px; }

        .chart-container { background: white; border-radius: 15px; padding: 20px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); margin-bottom: 30px; border: 1px solid #f1f5f9; }
    </style>
</head>
<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col">
                <div class="left_col scroll-view">
                    <div class="clearfix"></div>
                    <?php menu2(); menu1(); ?>
                </div>
            </div>
            <?php menu3(); ?>

            <div class="right_col" role="main" style="background-color: #f8fafc; min-height: 100vh;">
                
                <div class="row animated-box" style="margin-top: 47px;">
                    <div class="col-md-12">
                        <h3 style="margin-top:15px; margin-bottom: 25px; font-weight: 800; color: #1e293b; letter-spacing: -0.5px;">
                            <i class="fa fa-globe" style="color: #2473f2;"></i> Centro de Control Global
                        </h3>
                    </div>
                </div>

                <div class="row animated-box delay-1">
                    <div class="col-md-4 col-sm-12">
                        <div class="global-card bg-gradient-blue">
                            <div>
                                <span style="font-size:11px; font-weight:bold; opacity:0.8; text-transform:uppercase;">Ventas Totales (Hoy)</span>
                                <h2 style="margin:5px 0 0 0; font-weight:900; font-size:32px;">S/ <?php echo number_format($total_ventas_global, 2); ?></h2>
                            </div>
                            <i class="fa fa-line-chart global-icon"></i>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6">
                        <div class="global-card bg-gradient-green">
                            <div>
                                <span style="font-size:11px; font-weight:bold; opacity:0.8; text-transform:uppercase;">Cajas Abiertas (Activas)</span>
                                <h2 style="margin:5px 0 0 0; font-weight:900; font-size:32px;"><?php echo $cajas_abiertas_count; ?> <small style="color:white; font-size:16px;">/ <?php echo $total_tiendas_count; ?></small></h2>
                            </div>
                            <i class="fa fa-unlock global-icon"></i>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6">
                        <div class="global-card bg-gradient-purple">
                            <div>
                                <span style="font-size:11px; font-weight:bold; opacity:0.8; text-transform:uppercase;">Tiendas Operativas</span>
                                <h2 style="margin:5px 0 0 0; font-weight:900; font-size:32px;"><?php echo $total_tiendas_count; ?> <small style="color:white; font-size:16px;">Sedes</small></h2>
                            </div>
                            <i class="fa fa-building global-icon"></i>
                        </div>
                    </div>
                </div>

                <div class="row animated-box delay-2">
                    <div class="col-md-12">
                        <h4 style="font-weight: 800; color: #334155; margin-bottom: 20px; text-transform: uppercase; font-size: 14px; letter-spacing: 1px;"><i class="fa fa-bar-chart" style="color:#2473f2;"></i> Rendimiento de Ventas por Sucursal (Hoy)</h4>
                        <div class="chart-container">
                            <div id="ventas_sucursales_chart" style="height: 250px; width: 100%;"></div>
                        </div>
                    </div>
                </div>

                <div class="row animated-box delay-3">
                    <div class="col-md-12">
                        <h4 style="font-weight: 800; color: #334155; margin-top: 10px; margin-bottom: 20px; text-transform: uppercase; font-size: 14px; letter-spacing: 1px;"><i class="fa fa-desktop" style="color:#8b5cf6;"></i> Monitor de Cajas en Vivo</h4>
                    </div>
                    
                    <?php 
                    $count = 0;
                    foreach ($tiendas_data as $tienda): 
                        if ($count % 4 == 0 && $count > 0) echo '<div class="clearfix visible-md-block visible-lg-block"></div>';
                    ?>
                        <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class="store-card">
                                <?php if ($tienda['abierta']): ?>
                                    <div class="store-header header-open">
                                        <h5 style="margin:0; font-weight:800; font-size:15px;"><i class="fa fa-shopping-bag"></i> <?php echo htmlspecialchars($tienda['nombre']); ?></h5>
                                        <span class="label label-success" style="background: rgba(255,255,255,0.2); border: 1px solid rgba(255,255,255,0.4);">ABIERTA</span>
                                    </div>
                                    <div class="store-body">
                                        <div class="store-metric">
                                            <span class="metric-label">Ventas Turno</span>
                                            <span class="metric-value val-sales">S/ <?php echo number_format($tienda['ventas'], 2); ?></span>
                                        </div>
                                        <div class="store-metric">
                                            <span class="metric-label">Cajero</span>
                                            <span class="metric-value"><i class="fa fa-user" style="color:#94a3b8;"></i> <?php echo $tienda['usuario']; ?></span>
                                        </div>
                                        <div class="store-metric">
                                            <span class="metric-label">Hora Apertura</span>
                                            <span class="metric-value"><i class="fa fa-clock-o" style="color:#94a3b8;"></i> <?php echo $tienda['hora']; ?></span>
                                        </div>
                                        <div class="store-metric">
                                            <span class="metric-label">Monto Inicial</span>
                                            <span class="metric-value">S/ <?php echo number_format($tienda['apertura'], 2); ?></span>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="store-header header-closed">
                                        <h5 style="margin:0; font-weight:800; font-size:15px;"><i class="fa fa-shopping-bag"></i> <?php echo htmlspecialchars($tienda['nombre']); ?></h5>
                                        <span class="label label-danger" style="background: rgba(255,255,255,0.2); border: 1px solid rgba(255,255,255,0.4);">CERRADA</span>
                                    </div>
                                    <div class="store-body" style="background: #f8fafc; opacity: 0.8;">
                                        <div class="store-metric" style="border-bottom: none; display:block; text-align:center; padding: 20px 0;">
                                            <i class="fa fa-lock" style="font-size: 35px; color: #cbd5e1; margin-bottom: 10px; display:block;"></i>
                                            <span class="metric-label" style="display:block; margin-bottom: 5px;">Sin Turno Activo</span>
                                            <span class="metric-value" style="color:#94a3b8; font-size:11px;">Ventas de hoy: S/ <?php echo number_format($tienda['ventas'], 2); ?></span>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php 
                        $count++;
                    endforeach; 
                    ?>
                </div>

            </div>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="js/custom.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/raphael/2.1.0/raphael-min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.min.js"></script>

    <script>
        // RENDERIZAR GRÁFICO COMPARATIVO DE SUCURSALES
        $(function() {
            var ventas_data = [
                <?php echo $grafico_ventas_js; ?>
            ];
            
            if (ventas_data.length > 0) {
                Morris.Bar({
                    element: 'ventas_sucursales_chart',
                    data: ventas_data,
                    xkey: 'y',
                    ykeys: ['a'],
                    labels: ['Ventas S/ '],
                    barColors: function (row, series, type) {
                        return '#2473f2';
                    },
                    resize: true,
                    hideHover: 'auto',
                    gridLineColor: '#f1f5f9',
                    gridTextFamily: 'Poppins, sans-serif',
                    xLabelAngle: 15
                });
            } else {
                $("#ventas_sucursales_chart").html("<div style='text-align:center; color:#94a3b8; padding-top:80px;'><i class='fa fa-info-circle fa-2x'></i><br>No hay sucursales registradas.</div>");
            }
        });
    </script>
</body>
</html>