<?php
/**
 * RESUMEN_AL.PHP - DASHBOARD PARA ALMACENES
 * Control de inventario, traslados, accesos rápidos y métricas de salida.
 */
session_start();

// 1. SEGURIDAD
if (!isset($_SESSION['user_login_status']) || $_SESSION['user_login_status'] != 1) { 
    header("location: login.php"); 
    exit; 
}

include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

$tienda_actual = $_SESSION['tienda'] ?? 1; 
$user_id_actual = $_SESSION['user_id'] ?? 0;

// Datos de la sucursal/almacén actual
$sql_sucursal = mysqli_query($con, "SELECT nombre_stand, nombre FROM sucursal WHERE id_sucursal = '$tienda_actual'");
$rw_sucursal = mysqli_fetch_array($sql_sucursal);
$nombre_almacen = (!empty($rw_sucursal['nombre_stand'])) ? $rw_sucursal['nombre_stand'] : ($rw_sucursal['nombre'] ?? 'Mi Almacén');

// 2. MÉTRICAS DE INVENTARIO
$col_stock = 'b' . $tienda_actual; // Ej: b2 para el almacén 2

// A. Total de Productos Registrados
$q_total_prod = mysqli_query($con, "SELECT COUNT(*) as t FROM products");
$total_catalogo = ($q_total_prod && $r = mysqli_fetch_array($q_total_prod)) ? intval($r['t']) : 0;

// B. Total de Unidades Físicas
$q_unidades = mysqli_query($con, "SELECT SUM($col_stock) as t FROM products");
$unidades_fisicas = ($q_unidades && $r = mysqli_fetch_array($q_unidades)) ? floatval($r['t']) : 0;

// C. Productos con Stock Bajo
$q_bajo = mysqli_query($con, "SELECT COUNT(*) as t FROM products WHERE $col_stock > 0 AND $col_stock <= stockmin");
$stock_bajo = ($q_bajo && $r = mysqli_fetch_array($q_bajo)) ? intval($r['t']) : 0;

// D. Productos Agotados
$q_agotado = mysqli_query($con, "SELECT COUNT(*) as t FROM products WHERE $col_stock <= 0");
$stock_agotado = ($q_agotado && $r = mysqli_fetch_array($q_agotado)) ? intval($r['t']) : 0;

// Stock Saludable
$stock_saludable = $total_catalogo - ($stock_bajo + $stock_agotado);
if($stock_saludable < 0) $stock_saludable = 0;


// 3. TOP 5 PRODUCTOS CON MÁS SALIDA (VENTAS)
$top_productos = [];
$q_top = mysqli_query($con, "
    SELECT p.nombre_producto, SUM(d.cantidad) as total_vendido 
    FROM detalle_factura d 
    INNER JOIN facturas f ON d.id_factura = f.id_factura 
    INNER JOIN products p ON d.id_producto = p.id_producto 
    WHERE f.ven_com = 1 AND f.estado_factura <> 32 
    GROUP BY p.id_producto 
    ORDER BY total_vendido DESC 
    LIMIT 5
");

if ($q_top) {
    while ($r_top = mysqli_fetch_array($q_top)) {
        $nombre_limpio = addslashes(trim($r_top['nombre_producto']));
        $nombre_corto = (strlen($nombre_limpio) > 18) ? substr($nombre_limpio, 0, 15) . '...' : $nombre_limpio;
        $cantidad = floatval($r_top['total_vendido']);
        $top_productos[] = "{ y: '" . $nombre_corto . "', a: " . $cantidad . " }";
    }
}
$top_productos_js = implode(",\n", $top_productos);

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>Centro Logístico | SoundCrow</title>
    <link rel="icon" href="logo.ico">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.css">
    
    <style>
        /* ANIMACIONES */
        @keyframes fadeInUp { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }
        .animated-box { animation: fadeInUp 0.6s ease-out forwards; opacity: 0; }
        .delay-1 { animation-delay: 0.1s; } .delay-2 { animation-delay: 0.2s; } .delay-3 { animation-delay: 0.3s; }

        /* TARJETAS DE INVENTARIO */
        .dashboard-card { display: flex; align-items: center; padding: 20px 15px; border-radius: 15px; color: white; margin-bottom: 25px; box-shadow: 0 8px 20px rgba(0, 0, 0, 0.08); transition: transform 0.3s ease; min-height: 120px; }
        .dashboard-card:hover { transform: translateY(-5px); box-shadow: 0 12px 25px rgba(0, 0, 0, 0.15); }
        .card-icon { background: rgba(255, 255, 255, 0.25); width: 50px; height: 50px; min-width: 50px; border-radius: 50%; display: flex; justify-content: center; align-items: center; margin-right: 15px; backdrop-filter: blur(5px); }
        .card-value { margin: 0; font-size: 24px; font-weight: 800; line-height: 1; text-shadow: 1px 1px 2px rgba(0,0,0,0.1); }
        
        /* BANNER ALMACÉN */
        .almacen-banner { padding: 30px; border-radius: 15px; margin-bottom: 25px; color: white; display: flex; justify-content: space-between; align-items: center; position: relative; overflow: hidden; background: linear-gradient(135deg, #1e293b 0%, #334155 100%); box-shadow: 0 10px 20px rgba(30, 41, 59, 0.2); }
        .almacen-banner::after { content: ''; position: absolute; top: 0; right: 0; bottom: 0; width: 40%; background: linear-gradient(90deg, transparent, rgba(255,255,255,0.05)); transform: skewX(-20deg) translateX(30%); }
        
        /* ACCESOS RÁPIDOS */
        .action-btn { display: block; text-align: center; background: white; padding: 25px 15px; border-radius: 15px; color: #334155; text-decoration: none; border: 1px solid #f1f5f9; transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275); box-shadow: 0 4px 6px rgba(0,0,0,0.02); position: relative; overflow: hidden; cursor: pointer; }
        .action-btn::before { content: ''; position: absolute; top: -100%; left: 0; width: 100%; height: 100%; background: linear-gradient(to bottom, transparent, rgba(20, 184, 166, 0.05)); transition: all 0.4s ease; }
        .action-btn:hover { transform: translateY(-8px); box-shadow: 0 15px 30px rgba(0,0,0,0.08); text-decoration: none; border-color: #e2e8f0; color: #334155; }
        .action-btn:hover::before { top: 0; }
        .action-btn i { font-size: 40px; margin-bottom: 15px; display: block; transition: transform 0.3s ease; }
        .action-btn:hover i { transform: scale(1.1); }
        .action-btn span { display: block; font-weight: 800; font-size: 14px; text-transform: uppercase; letter-spacing: 0.5px; }
        
        .chart-container { background: white; border-radius: 15px; padding: 20px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); margin-bottom: 30px; border: 1px solid #f1f5f9; display: flex; justify-content: center; align-items: center; height: 350px;}
        
        /* SEARCH BAR MODAL */
        .search-input-modal { border-radius: 30px; border: 2px solid #e2e8f0; padding: 20px 25px; height: 60px; font-size: 18px; box-shadow: 0 4px 6px rgba(0,0,0,0.02); transition: 0.3s; }
        .search-input-modal:focus { border-color: #14b8a6; box-shadow: 0 4px 15px rgba(20, 184, 166, 0.15); outline: none; }
    </style>
</head>
<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col">
                <div class="left_col scroll-view">
                    <div class="clearfix"></div>
                    <?php menu2(); menu1(); ?>
                </div>
            </div>
            <?php menu3(); ?>

            <div class="right_col" role="main" style="background-color: #f8fafc; min-height: 100vh;">
                
                <div class="modal fade" id="modalBuscarProducto" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                    <div class="modal-dialog" role="document" style="width: 850px; max-width: 95%;">
                        <div class="modal-content" style="border-radius: 15px; border: none; overflow: hidden; box-shadow: 0 15px 40px rgba(0,0,0,0.25);">
                            <div class="modal-header sc-header" style="background: linear-gradient(90deg, #14b8a6 0%, #0f766e 100%); padding: 20px 30px; border:none; display:flex; align-items:center;">
                                <h4 class="modal-title" style="color:white; font-weight:800; margin:0; width:100%; text-align:left; letter-spacing: 0.5px;">
                                    <i class='fa fa-search' style="margin-right: 10px; opacity: 0.8;"></i> Localizador de Inventario Global
                                </h4>
                                <button type="button" class="close" data-dismiss="modal" style="color:white; opacity:1; text-shadow:none; font-size:30px; outline:none;">&times;</button>
                            </div>
                            <div class="modal-body sc-body" style="padding: 30px; background: #f8fafc;">
                                <div class="form-group" style="margin-bottom: 25px; position:relative;">
                                    <i class="fa fa-barcode" style="position: absolute; left: 20px; top: 18px; font-size: 24px; color: #14b8a6; z-index: 10;"></i>
                                    <input type="text" class="form-control search-input-modal" id="q_producto" placeholder="Escanea código o escribe el nombre del producto..." onkeyup="load_stock_global(1);" style="padding-left: 60px;">
                                </div>
                                <div id="loader_stock" style="text-align: center; display:none; margin-bottom:15px;">
                                    <img src="./img/ajax-loader.gif"> Consultando existencias...
                                </div>
                                <div id="resultados_stock_global" style="max-height: 450px; overflow-y: auto; overflow-x: hidden; padding-right: 5px;"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row animated-box" style="margin-top: 46px;">
                    <div class="col-md-12 ">
                        <h3 style="margin-top:15px; margin-bottom: 25px; font-weight: 800; color: #1e293b; letter-spacing: -0.5px;">
                            <i class="fa fa-archive" style="color: #14b8a6;"></i> Logística: <?php echo $nombre_almacen; ?>
                        </h3>
                    </div>
                </div>

                <div class="row animated-box delay-1">
                    <div class="col-md-12">
                        <div class="almacen-banner">
                            <div>
                                <h2 style="margin:0; font-weight:800; text-transform: uppercase; letter-spacing: 1px; color:#38bdf8;"><i class="fa fa-cogs"></i> Operaciones en Curso</h2>
                                <p style="margin:5px 0 0 0; font-size:15px; opacity:0.9;">Supervisa entradas, salidas y mantén el orden del stock.</p>
                            </div>
                            <div style="background: rgba(255,255,255,0.1); padding: 15px 25px; border-radius: 12px; text-align: center; border: 1px solid rgba(255,255,255,0.2);">
                                <span style="display:block; font-size: 11px; font-weight: bold; color: #cbd5e1; text-transform: uppercase;">Unidades Físicas Resguardadas</span>
                                <h3 style="margin:0; font-weight: 900; color: white;"><?php echo number_format($unidades_fisicas, 0); ?> <small style="font-size: 14px; color:#94a3b8;">UND</small></h3>
                            </div>
                        </div>
                    </div>
                </div>

                                <div class="row animated-box delay-2" style="margin-bottom: 10px;">
                    <div class="col-md-3 col-sm-6 col-xs-12" style="margin-bottom: 20px;">
                        <a href="nueva_entrada.php" class="action-btn">
                            <i class="fa fa-truck" style="color:#0ea5e9;"></i>
                            <span style="color:#0ea5e9;">Entrada Mercadería</span>
                            <small>Recepcionar compras / Guías</small>
                        </a>
                    </div>
                    <div class="col-md-3 col-sm-6 col-xs-12" style="margin-bottom: 20px;">
                        <a href="nuevo_traslado.php" class="action-btn">
                            <i class="fa fa-exchange" style="color:#8b5cf6;"></i>
                            <span style="color:#8b5cf6;">Realizar Traslado</span>
                            <small>Enviar stock a sucursales</small>
                        </a>
                    </div>
                    <div class="col-md-3 col-sm-6 col-xs-12" style="margin-bottom: 20px;">
                        <a href="ingresoproductos.php" class="action-btn">
                            <i class="fa fa-plus-square" style="color:#10b981;"></i>
                            <span style="color:#10b981;">Crear Producto</span>
                            <small>Dar de alta nuevo código</small>
                        </a>
                    </div>
                    <div class="col-md-3 col-sm-6 col-xs-12" style="margin-bottom: 20px;">
                        <a class="action-btn" data-toggle="modal" data-target="#modalBuscarProducto" onclick="setTimeout(function(){$('#q_producto').focus();}, 500);">
                            <i class="fa fa-search" style="color:#f59e0b;"></i>
                            <span style="color:#f59e0b;">Buscar Producto</span>
                            <small>Verificar stock en todas las sedes</small>
                        </a>
                    </div>
                </div>

                <div class="row animated-box delay-3">
                    <div class="col-md-12">
                        <h4 style="font-weight: 800; color: #334155; margin-bottom: 20px; text-transform: uppercase; font-size: 14px; letter-spacing: 1px;">Estado del Catálogo Local</h4>
                    </div>
                    
                    <div class="col-md-3 col-sm-6 col-xs-12">
                        <div class="dashboard-card" style="background: linear-gradient(135deg, #0ea5e9, #2563eb);">
                            <div class="card-icon"><i class="fa fa-cubes"></i></div>
                            <div>
                                <span style="font-size:10px; font-weight:700; opacity:0.8;">CATÁLOGO TOTAL</span>
                                <h2 class="card-value"><?php echo number_format($total_catalogo, 0); ?></h2>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-3 col-sm-6 col-xs-12">
                        <div class="dashboard-card" style="background: linear-gradient(135deg, #14b8a6, #0f766e);">
                            <div class="card-icon"><i class="fa fa-check-circle"></i></div>
                            <div>
                                <span style="font-size:10px; font-weight:700; opacity:0.8;">STOCK SALUDABLE</span>
                                <h2 class="card-value"><?php echo number_format($stock_saludable, 0); ?></h2>
                            </div>
                        </div>
                    </div>
                    
                    <div class="clearfix visible-sm-block"></div>
                    
                    <div class="col-md-3 col-sm-6 col-xs-12">
                        <div class="dashboard-card" style="background: linear-gradient(135deg, #f59e0b, #b45309);">
                            <div class="card-icon"><i class="fa fa-warning"></i></div>
                            <div>
                                <span style="font-size:10px; font-weight:700; opacity:0.8;">ALERTA STOCK BAJO</span>
                                <h2 class="card-value"><?php echo number_format($stock_bajo, 0); ?></h2>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-3 col-sm-6 col-xs-12">
                        <div class="dashboard-card" style="background: linear-gradient(135deg, #ef4444, #991b1b);">
                            <div class="card-icon"><i class="fa fa-times-circle"></i></div>
                            <div>
                                <span style="font-size:10px; font-weight:700; opacity:0.8;">PRODUCTOS AGOTADOS</span>
                                <h2 class="card-value"><?php echo number_format($stock_agotado, 0); ?></h2>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row animated-box delay-3" style="margin-top: 10px;">
                    
                    <div class="col-md-6 col-sm-12">
                        <h4 style="font-weight: 800; color: #334155; margin-bottom: 20px; text-transform: uppercase; font-size: 14px; letter-spacing: 1px;"><i class="fa fa-pie-chart" style="color:#14b8a6;"></i> Salud del Inventario</h4>
                        <div class="chart-container">
                            <div id="inventario_donut" style="height: 280px; width: 100%;"></div>
                        </div>
                    </div>
                    
                    <div class="col-md-6 col-sm-12">
                        <h4 style="font-weight: 800; color: #334155; margin-bottom: 20px; text-transform: uppercase; font-size: 14px; letter-spacing: 1px;"><i class="fa fa-bar-chart" style="color:#8b5cf6;"></i> Top 5: Productos con Más Salida</h4>
                        <div class="chart-container">
                            <div id="top_productos_chart" style="height: 280px; width: 100%;"></div>
                        </div>
                    </div>

                </div>

            </div>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="js/custom.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/raphael/2.1.0/raphael-min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.min.js"></script>

    <script>
        // RENDERIZAR GRÁFICOS
        $(function() {
            
            // 1. Gráfico Donut (Salud de inventario)
            var data_donut = [];
            if (<?php echo $stock_saludable; ?> == 0 && <?php echo $stock_bajo; ?> == 0 && <?php echo $stock_agotado; ?> == 0) {
                data_donut = [{label: "Sin Datos", value: 1}];
            } else {
                data_donut = [
                    {label: "Saludable", value: <?php echo $stock_saludable; ?>},
                    {label: "Bajo Stock", value: <?php echo $stock_bajo; ?>},
                    {label: "Agotados", value: <?php echo $stock_agotado; ?>}
                ];
            }

            Morris.Donut({
                element: 'inventario_donut',
                data: data_donut,
                colors: ['#14b8a6', '#f59e0b', '#ef4444'], // Teal, Naranja, Rojo
                formatter: function (y) { return y + " Items" },
                resize: true
            });
            
            // 2. Gráfico de Barras (Top 5 Salidas)
            var top_data = [
                <?php echo $top_productos_js; ?>
            ];
            
            if (top_data.length > 0) {
                Morris.Bar({
                    element: 'top_productos_chart',
                    data: top_data,
                    xkey: 'y',
                    ykeys: ['a'],
                    labels: ['Unidades de Salida'],
                    barColors: ['#8b5cf6'], // Morado vibrante
                    resize: true,
                    hideHover: 'auto',
                    gridLineColor: '#f1f5f9',
                    gridTextFamily: 'Poppins, sans-serif',
                    xLabelAngle: 20
                });
            } else {
                $("#top_productos_chart").html("<div style='text-align:center; color:#94a3b8; padding-top:100px;'><i class='fa fa-info-circle fa-2x'></i><br>Aún no hay registros de salidas suficientes.</div>");
            }
        });

        // FUNCIÓN AJAX PARA BUSCAR STOCK GLOBAL EN EL MODAL
        function load_stock_global(page){
            var q = $("#q_producto").val();
            if(q.trim() !== '') {
                $("#loader_stock").fadeIn('fast');
                $.ajax({
                    url: './ajax/buscar_producto_stock.php?action=ajax&page='+page+'&q='+encodeURIComponent(q),
                    success: function(data){
                        $("#resultados_stock_global").html(data).fadeIn('fast');
                        $("#loader_stock").fadeOut('fast');
                    }
                });
            } else {
                $("#resultados_stock_global").html('');
            }
        }
    </script>
</body>
</html>