<?php
/**
 * RESUMEN_T.PHP - DASHBOARD PARA TIENDAS / VENDEDORES
 * UI Premium, Gráficos, Seguridad de Caja y Consulta de Stock Global.
 */
session_start();

// 1. SEGURIDAD
if (!isset($_SESSION['user_login_status']) || $_SESSION['user_login_status'] != 1) { 
    header("location: login.php"); 
    exit; 
}

include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

$tienda1 = $_SESSION['tienda'] ?? 1; 
$user_id_actual = $_SESSION['user_id'] ?? 0;
date_default_timezone_set('America/Lima');
$fecha_hoy = date("Y-m-d");

// Datos de la sucursal actual
$sql_sucursal = mysqli_query($con, "SELECT nombre_stand, nombre FROM sucursal WHERE id_sucursal = '$tienda1'");
$rw_sucursal = mysqli_fetch_array($sql_sucursal);
$nombre_tienda = (!empty($rw_sucursal['nombre_stand'])) ? $rw_sucursal['nombre_stand'] : ($rw_sucursal['nombre'] ?? 'Mi Tienda');

// 2. VERIFICAR ESTADO DE CAJA
$sql_caja = mysqli_query($con, "SELECT c.id_caja, c.inicio, c.fec_reg, c.usuario_inicio, u.nombres FROM caja c INNER JOIN users u ON c.usuario_inicio = u.user_id WHERE c.tienda = '$tienda1' AND c.usuario_cierre = 0 LIMIT 1");
$caja_abierta = ($sql_caja) ? mysqli_fetch_array($sql_caja) : false;

$monto_apertura = 0; $ventas_dia_bruto = 0; $total_egresos = 0; $monto_total_caja = 0; $ingreso_total = 0; $id_caja_actual = 0;

if ($caja_abierta) {
    $id_caja_actual = $caja_abierta['id_caja'];
    $monto_apertura = floatval($caja_abierta['inicio']);
    $inicio_turno = $caja_abierta['fec_reg'];

    $q_v = mysqli_query($con, "SELECT SUM(total_venta) as t FROM facturas WHERE tienda='$tienda1' AND ven_com=1 AND estado_factura<>32 AND fecha_factura >= '$inicio_turno'");
    $ventas_dia_bruto = ($q_v && $r = mysqli_fetch_array($q_v)) ? floatval($r['t']) : 0;

    $q_ingreso = mysqli_query($con, "SELECT SUM(total_venta - deuda_total) as t FROM facturas WHERE tienda='$tienda1' AND ven_com=1 AND estado_factura<>32 AND fecha_factura >= '$inicio_turno'");
    $ingreso_efectivo = ($q_ingreso && $r = mysqli_fetch_array($q_ingreso)) ? floatval($r['t']) : 0;

    $q_abonos = mysqli_query($con, "SELECT SUM(p.importe_pago) as t FROM pagos p INNER JOIN facturas f ON p.id_factura = f.id_factura WHERE f.tienda='$tienda1' AND f.ven_com=1 AND p.fecha_pago >= DATE('$inicio_turno')");
    $abonos_ventas = ($q_abonos && $r = mysqli_fetch_array($q_abonos)) ? floatval($r['t']) : 0;

    $ingreso_total = $ingreso_efectivo + $abonos_ventas;

    $q_compras = mysqli_query($con, "SELECT SUM(total_venta - deuda_total) as t FROM facturas WHERE tienda='$tienda1' AND ven_com=2 AND estado_factura<>32 AND fecha_factura >= '$inicio_turno'");
    if ($q_compras && $r = mysqli_fetch_array($q_compras)) { $total_egresos += floatval($r['t']); }

    $q_pagos_compras = mysqli_query($con, "SELECT SUM(p.importe_pago) as t FROM pagos p INNER JOIN facturas f ON p.id_factura = f.id_factura WHERE f.tienda='$tienda1' AND f.ven_com=2 AND p.fecha_pago >= DATE('$inicio_turno')");
    if ($q_pagos_compras && $r = mysqli_fetch_array($q_pagos_compras)) { $total_egresos += floatval($r['t']); }

    $q_gastos = mysqli_query($con, "SELECT SUM(monto) as t FROM gastos WHERE tienda='$tienda1' AND fecha_agregado >= '$inicio_turno'");
    if ($q_gastos && $r = mysqli_fetch_array($q_gastos)) { $total_egresos += floatval($r['t']); }

    $monto_total_caja = ($monto_apertura + $ingreso_total) - $total_egresos;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>Dashboard Tienda | SoundCrow</title>
    <link rel="icon" href="logo.ico">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.css">
    
    <style>
        @keyframes fadeInUp { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }
        @keyframes pulseAlert { 0% { box-shadow: 0 0 0 0 rgba(239, 68, 68, 0.4); } 70% { box-shadow: 0 0 0 15px rgba(239, 68, 68, 0); } 100% { box-shadow: 0 0 0 0 rgba(239, 68, 68, 0); } }
        
        .animated-box { animation: fadeInUp 0.6s ease-out forwards; opacity: 0; }
        .delay-1 { animation-delay: 0.1s; } .delay-2 { animation-delay: 0.2s; } .delay-3 { animation-delay: 0.3s; }

        .dashboard-card { display: flex; align-items: center; padding: 25px 20px; border-radius: 15px; color: white; margin-bottom: 25px; box-shadow: 0 8px 20px rgba(0, 0, 0, 0.08); transition: transform 0.3s ease; }
        .dashboard-card:hover { transform: translateY(-5px); box-shadow: 0 12px 25px rgba(0, 0, 0, 0.15); }
        .card-icon { background: rgba(255, 255, 255, 0.25); width: 60px; height: 60px; border-radius: 50%; display: flex; justify-content: center; align-items: center; margin-right: 15px; backdrop-filter: blur(5px); }
        .card-value { margin: 0; font-size: 28px; font-weight: 800; line-height: 1; text-shadow: 1px 1px 2px rgba(0,0,0,0.1); }
        .bg-purple { background: linear-gradient(135deg, #6610f2, #8e44ad); }
        .bg-green { background: linear-gradient(135deg, #10b981, #059669); }
        .bg-red { background: linear-gradient(135deg, #ef4444, #b91c1c); }
        .bg-blue { background: linear-gradient(135deg, #0ea5e9, #2563eb); }
        
        .caja-banner { padding: 30px; border-radius: 15px; margin-bottom: 25px; color: white; display: flex; justify-content: space-between; align-items: center; position: relative; overflow: hidden; }
        .caja-banner::after { content: ''; position: absolute; top: 0; right: 0; bottom: 0; width: 30%; background: linear-gradient(90deg, transparent, rgba(255,255,255,0.1)); transform: skewX(-20deg) translateX(50%); }
        .caja-abierta { background: linear-gradient(135deg, #047857 0%, #10b981 100%); box-shadow: 0 10px 20px rgba(16, 185, 129, 0.2); }
        .caja-cerrada { background: linear-gradient(135deg, #991b1b 0%, #ef4444 100%); animation: pulseAlert 2s infinite; }
        
        .action-btn { display: block; text-align: center; background: white; padding: 25px 15px; border-radius: 15px; color: #334155; text-decoration: none; border: 1px solid #f1f5f9; transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275); box-shadow: 0 4px 6px rgba(0,0,0,0.02); position: relative; overflow: hidden; cursor: pointer; }
        .action-btn::before { content: ''; position: absolute; top: -100%; left: 0; width: 100%; height: 100%; background: linear-gradient(to bottom, transparent, rgba(36, 115, 242, 0.05)); transition: all 0.4s ease; }
        .action-btn:hover { transform: translateY(-8px); box-shadow: 0 15px 30px rgba(0,0,0,0.08); text-decoration: none; border-color: #e2e8f0; color: #334155; }
        .action-btn:hover::before { top: 0; }
        .action-btn i { font-size: 45px; margin-bottom: 15px; display: block; transition: transform 0.3s ease; }
        .action-btn:hover i { transform: scale(1.1); }
        .action-btn span { display: block; font-weight: 800; font-size: 15px; text-transform: uppercase; letter-spacing: 0.5px; }
        
        .chart-container { background: white; border-radius: 15px; padding: 25px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); margin-bottom: 30px; border: 1px solid #f1f5f9; }
        
        /* SEARCH BAR MODAL */
        .search-input-modal { border-radius: 30px; border: 2px solid #e2e8f0; padding: 20px 25px; height: 60px; font-size: 18px; box-shadow: 0 4px 6px rgba(0,0,0,0.02); transition: 0.3s; }
        .search-input-modal:focus { border-color: #8e44ad; box-shadow: 0 4px 15px rgba(142, 68, 173, 0.15); outline: none; }
    </style>
</head>
<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col">
                <div class="left_col scroll-view">
                    <div class="clearfix"></div>
                    <?php menu2(); menu1(); ?>
                </div>
            </div>
            <?php menu3(); ?>

            <div class="right_col" role="main" style="background-color: #f8fafc; min-height: 100vh;">
                
                <?php include("modal/registro_caja.php"); include("modal/editar_caja.php"); ?>

                <div class="modal fade" id="modalBuscarProducto" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                    <div class="modal-dialog" role="document" style="width: 850px; max-width: 95%;">
                        <div class="modal-content" style="border-radius: 15px; border: none; overflow: hidden; box-shadow: 0 15px 40px rgba(0,0,0,0.25);">
                            <div class="modal-header sc-header" style="background: linear-gradient(90deg, #8e44ad 0%, #6610f2 100%); padding: 20px 30px; border:none; display:flex; align-items:center;">
                                <h4 class="modal-title" style="color:white; font-weight:800; margin:0; width:100%; text-align:left; letter-spacing: 0.5px;">
                                    <i class='fa fa-search' style="margin-right: 10px; opacity: 0.8;"></i> Buscar Stock en Todas las Sucursales
                                </h4>
                                <button type="button" class="close" data-dismiss="modal" style="color:white; opacity:1; text-shadow:none; font-size:30px; outline:none;">&times;</button>
                            </div>
                            <div class="modal-body sc-body" style="padding: 30px; background: #f8fafc;">
                                <div class="form-group" style="margin-bottom: 25px; position:relative;">
                                    <i class="fa fa-barcode" style="position: absolute; left: 20px; top: 18px; font-size: 24px; color: #8e44ad; z-index: 10;"></i>
                                    <input type="text" class="form-control search-input-modal" id="q_producto" placeholder="Escanea código de barras o escribe el nombre del producto..." onkeyup="load_stock_global(1);" style="padding-left: 60px;">
                                </div>
                                <div id="loader_stock" style="text-align: center; display:none; margin-bottom:15px;">
                                    <img src="./img/ajax-loader.gif"> Consultando base de datos...
                                </div>
                                <div id="resultados_stock_global" style="max-height: 450px; overflow-y: auto; overflow-x: hidden; padding-right: 5px;">
                                    </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row animated-box" style="margin-top: 47px;">
                    <div class="col-md-12">
                        <h3 style="margin-top:15px; margin-bottom: 25px; font-weight: 800; color: #1e293b; letter-spacing: -0.5px;">
                            <i class="fa fa-shopping-bag" style="color: #2473f2;"></i> Mi Tienda: <?php echo $nombre_tienda; ?>
                        </h3>
                    </div>
                </div>

                <div class="row animated-box delay-1">
                    <div class="col-md-12">
                        <?php if ($caja_abierta): ?>
                            <div class="caja-banner caja-abierta">
                                <div>
                                    <h2 style="margin:0; font-weight:800; text-transform: uppercase; letter-spacing: 1px;"><i class="fa fa-unlock"></i> Turno Activo</h2>
                                    <p style="margin:5px 0 0 0; font-size:15px; opacity:0.9;">Aperturada por <strong><?php echo $caja_abierta['nombres']; ?></strong> a las <?php echo date('h:i A', strtotime($caja_abierta['fec_reg'])); ?></p>
                                </div>
                                <?php if ($user_id_actual == $caja_abierta['usuario_inicio']): ?>
                                    <button type="button" class="btn btn-default" onclick="preparar_cierre('<?php echo $id_caja_actual; ?>')" data-toggle="modal" data-target="#myModal2" style="border-radius:30px; font-weight:800; color:#047857; border:none; padding:12px 25px; box-shadow: 0 4px 10px rgba(0,0,0,0.15); transition: 0.3s; text-transform: uppercase;">
                                        <i class="fa fa-lock"></i> Finalizar Turno
                                    </button>
                                <?php else: ?>
                                    <button type="button" class="btn btn-default" disabled style="border-radius:30px; font-weight:bold; color:#f8fafc; border:none; padding:10px 20px; background-color: rgba(255,255,255,0.2);">
                                        <i class="fa fa-ban"></i> Solo <?php echo $caja_abierta['nombres']; ?> puede cerrar
                                    </button>
                                <?php endif; ?>
                            </div>
                        <?php else: ?>
                            <div class="caja-banner caja-cerrada">
                                <div>
                                    <h2 style="margin:0; font-weight:800; letter-spacing: 1px;"><i class="fa fa-lock"></i> CAJA CERRADA</h2>
                                    <p style="margin:5px 0 0 0; font-size:15px; opacity:0.9;">Apertura la caja para iniciar tus operaciones y ventas.</p>
                                </div>
                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#nuevoProducto" style="border-radius:30px; font-weight:800; color:#991b1b; border:none; padding:12px 25px; box-shadow: 0 4px 10px rgba(0,0,0,0.2); transition: 0.3s; text-transform: uppercase;">
                                    <i class="fa fa-bolt"></i> Aperturar Ahora
                                </button>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="row animated-box delay-2" style="margin-bottom: 10px;">
                    <div class="col-md-4 col-sm-4 col-xs-12" style="margin-bottom: 20px;">
                        <a href="nueva_factura.php" class="action-btn">
                            <i class="fa fa-credit-card" style="color:#10b981;"></i>
                            <span style="color:#10b981;">Nueva Venta</span>
                            <small>Factura o Boleta al instante</small>
                        </a>
                    </div>
                    <div class="col-md-4 col-sm-4 col-xs-12" style="margin-bottom: 20px;">
                        <a class="action-btn" data-toggle="modal" data-target="#modalBuscarProducto" onclick="setTimeout(function(){$('#q_producto').focus();}, 500);">
                            <i class="fa fa-search" style="color:#8e44ad;"></i>
                            <span style="color:#8e44ad;">Buscar Productos</span>
                            <small>Consulta stock en todas las tiendas</small>
                        </a>
                    </div>
                    <div class="col-md-4 col-sm-4 col-xs-12" style="margin-bottom: 20px;">
                        <a href="productos.php" class="action-btn">
                            <i class="fa fa-cubes" style="color:#f59e0b;"></i>
                            <span style="color:#f59e0b;">Inventario Local</span>
                            <small>Catálogo de mi sucursal</small>
                        </a>
                    </div>
                </div>

                <?php if ($caja_abierta): ?>
                <div class="row animated-box delay-3">
                    <div class="col-md-6">
                        <h4 style="font-weight: 800; color: #334155; margin-bottom: 20px; text-transform: uppercase; font-size: 14px; letter-spacing: 1px;">Flujo de Efectivo</h4>
                        <div class="row">
                            <div class="col-md-6 col-xs-6"><div class="dashboard-card bg-purple"><div class="card-icon"><i class="fa fa-play"></i></div><div><span style="font-size:10px; font-weight:700; opacity:0.8;">APERTURA</span><h2 class="card-value">S/ <?php echo number_format($monto_apertura, 2); ?></h2></div></div></div>
                            <div class="col-md-6 col-xs-6"><div class="dashboard-card bg-green"><div class="card-icon"><i class="fa fa-arrow-up"></i></div><div><span style="font-size:10px; font-weight:700; opacity:0.8;">INGRESOS</span><h2 class="card-value">S/ <?php echo number_format($ingreso_total, 2); ?></h2></div></div></div>
                            <div class="col-md-6 col-xs-6"><div class="dashboard-card bg-red"><div class="card-icon"><i class="fa fa-arrow-down"></i></div><div><span style="font-size:10px; font-weight:700; opacity:0.8;">EGRESOS</span><h2 class="card-value">S/ <?php echo number_format($total_egresos, 2); ?></h2></div></div></div>
                            <div class="col-md-6 col-xs-6"><div class="dashboard-card bg-blue"><div class="card-icon"><i class="fa fa-money"></i></div><div><span style="font-size:10px; font-weight:700; opacity:0.8;">TOTAL CAJA</span><h2 class="card-value">S/ <?php echo number_format($monto_total_caja, 2); ?></h2></div></div></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <h4 style="font-weight: 800; color: #334155; margin-bottom: 20px; text-transform: uppercase; font-size: 14px; letter-spacing: 1px;">Balance Visual</h4>
                        <div class="chart-container"><div id="caja_chart" style="height: 230px;"></div></div>
                    </div>
                </div>
                <?php endif; ?>

            </div>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="js/custom.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/raphael/2.1.0/raphael-min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.min.js"></script>

    <script>
        // FUNCIÓN AJAX PARA BUSCAR STOCK GLOBAL
        function load_stock_global(page){
            var q = $("#q_producto").val();
            if(q.trim() !== '') {
                $("#loader_stock").fadeIn('fast');
                $.ajax({
                    url: './ajax/buscar_producto_stock.php?action=ajax&page='+page+'&q='+encodeURIComponent(q),
                    success: function(data){
                        $("#resultados_stock_global").html(data).fadeIn('fast');
                        $("#loader_stock").fadeOut('fast');
                    }
                });
            } else {
                $("#resultados_stock_global").html('');
            }
        }

        <?php if ($caja_abierta): ?>
        $(function() {
            Morris.Bar({
                element: 'caja_chart',
                data: [ { y: 'Apertura', a: <?php echo $monto_apertura; ?> }, { y: 'Ingresos', a: <?php echo $ingreso_total; ?> }, { y: 'Egresos',  a: <?php echo $total_egresos; ?> }, { y: 'Saldo',    a: <?php echo $monto_total_caja; ?> } ],
                xkey: 'y', ykeys: ['a'], labels: ['Monto S/ '],
                barColors: function (row, series, type) {
                    if(row.label == "Apertura") return "#8e44ad"; else if(row.label == "Ingresos") return "#10b981"; else if(row.label == "Egresos") return "#ef4444"; else if(row.label == "Saldo") return "#0ea5e9";
                }, resize: true, hideHover: 'auto', gridLineColor: '#f1f5f9', gridTextFamily: 'Poppins, sans-serif'
            });
        });
        <?php endif; ?>

        function preparar_cierre(id_caja) { $("#mod_id").val(id_caja); }

        $( "#guardar_caja" ).submit(function( event ) {
            $('#guardar_datos').attr("disabled", true);
            $.ajax({ type: "POST", url: "ajax/nuevo_caja.php", data: $(this).serialize(),
                beforeSend: function(){ $("#resultados_ajax").html('<div class="alert alert-info">Aperturando caja...</div>'); },
                success: function(datos){ $("#resultados_ajax").html(datos); $('#guardar_datos').attr("disabled", false); if(datos.indexOf('alert-success') > -1){ setTimeout(function(){ location.reload(); }, 1200); } }
            }); event.preventDefault();
        });

        $( "#editar_caja" ).submit(function( event ) {
            $('#actualizar_datos').attr("disabled", true);
            $.ajax({ type: "POST", url: "ajax/editar_caja.php", data: $(this).serialize(),
                beforeSend: function(){ $("#resultados_ajax2").html('<div class="alert alert-info">Procesando cierre...</div>'); },
                success: function(datos){ $("#resultados_ajax2").html(datos); $('#actualizar_datos').attr("disabled", false); if(datos.indexOf('alert-success') > -1){ setTimeout(function(){ location.reload(); }, 1200); } }
            }); event.preventDefault();
        });
    </script>
</body>
</html>