<?php
// 1. CONFIGURACIÓN Y SEGURIDAD
session_start();
include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

// Validar Sesión
if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
    header("location: login.php");
    exit;
}

// Validar Permisos (Índice 2 para Sucursales)
$sql1="select * from users where user_id='".$_SESSION['user_id']."'";
$rw1=mysqli_query($con,$sql1);
$rs1=mysqli_fetch_array($rw1);
$modulo=$rs1["accesos"];
$a = explode(".", $modulo); 

if($a[24]==0){
    header("location:error.php");    
    exit;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Lista de Sucursales | SoundCrow</title>
    <link rel="icon" href="logo.ico">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        body { font-family: 'Poppins', sans-serif !important; background-color: #F0F2F5; color: #334155; }
        
        .sc-card {
            background: #ffffff;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.05);
            border: none;
            overflow: hidden;
            margin-bottom: 30px;
        }

        .sc-header {
            background: linear-gradient(90deg, #0a2463 0%, #2473f2 100%);
            padding: 20px 30px;
            color: white;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .sc-title {
            margin: 0;
            font-size: 18px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: white;
        }

        .sc-body { padding: 30px; }

        /* Botón Nuevo */
        .btn-sc-new {
            background-color: rgba(255,255,255,0.2);
            color: white;
            border: 1px solid rgba(255,255,255,0.4);
            border-radius: 50px;
            padding: 8px 20px;
            font-weight: 600;
            font-size: 13px;
            transition: all 0.3s;
        }
        .btn-sc-new:hover {
            background-color: white;
            color: #0a2463;
        }

        /* Input Búsqueda */
        .form-control-sc {
            border-radius: 8px;
            border: 1px solid #e2e8f0;
            padding: 10px 15px;
            height: 45px;
            background-color: #f8fafc;
            width: 100%;
            transition: 0.3s;
        }
        .form-control-sc:focus {
            background-color: #fff;
            border-color: #2473f2;
            box-shadow: 0 0 0 3px rgba(36, 115, 242, 0.1);
            outline: none;
        }
        
        /* Labels */
        .form-label-sc {
            font-weight: 600; 
            color: #64748b; 
            font-size: 11px; 
            text-transform: uppercase;
        }
    </style>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            
            <div class="col-md-3 left_col">
                <div class="left_col scroll-view">
                    <div class="clearfix"></div>
                    <?php menu2(); menu1(); ?>
                </div>
            </div>

            <?php menu3(); ?>
      
            <div class="right_col" role="main">
                <div class="">
                    <div class="page-title"></div>
                    <div class="clearfix"></div>

                    <div class="row">
                        <div class="container">
                            
                            <div class="sc-card">
                                <div class="sc-header">
                                    <div>
                                        <h3 class="sc-title"><i class="fa fa-building"></i> Gestión de Sucursales</h3>
                                    </div>
                                    <div>
                                        <button type='button' class="btn btn-sc-new" data-toggle="modal" data-target="#nuevoProducto">
                                            <i class="fa fa-plus"></i> Nueva Sucursal
                                        </button>
                                    </div>
                                </div>

                                <div class="sc-body">
                                    <?php
                                        include("modal/registro_sucursal.php");
                                        include("modal/editar_sucursal.php");
                                        include("modal/editar_logo_sucursal.php"); // Nuevo modal de logo
                                    ?>
                                    
                                    <form class="form-horizontal" onsubmit="event.preventDefault();">
                                        <div class="row" style="margin-bottom: 25px;">
                                            <div class="col-md-8">
                                                <input type="text" class="form-control-sc" id="q" placeholder="🔍 Buscar por nombre, tienda o RUC..." onkeyup='load(1);'>
                                            </div>
                                            <div class="col-md-4 text-right">
                                                <span id="loader"></span>
                                            </div>
                                        </div>
                                    </form>

                                    <div id="resultados"></div>
                                    <div class='outer_div'></div>

                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="js/custom.js"></script>

    <script>
        $(document).ready(function(){
            load(1);
        });

        // 1. CARGAR TABLA
        function load(page){
            var q= $("#q").val();
            $("#loader").fadeIn('slow');
            $.ajax({
                url:'./ajax/buscar_sucursal.php?action=ajax&page='+page+'&q='+q,
                beforeSend: function(objeto){
                    $('#loader').html('<img src="./img/ajax-loader.gif"> Cargando...');
                },
                success:function(data){
                    $(".outer_div").html(data).fadeIn('slow');
                    $('#loader').html('');
                }
            })
        }

        // 2. ELIMINAR SUCURSAL
        function eliminar(id){
            var q= $("#q").val();
            if (confirm("¿Realmente deseas eliminar esta sucursal?")){    
                $.ajax({
                    type: "GET",
                    url: "./ajax/buscar_sucursal.php",
                    data: "id="+id,
                    beforeSend: function(objeto){
                        $("#resultados").html("Procesando...");
                    },
                    success: function(datos){
                        $("#resultados").html(datos);
                        load(1);
                        setTimeout(function() { $(".alert").fadeOut(); }, 3000);
                    }
                });
            }
        }

        // 3. GUARDAR NUEVA SUCURSAL (Con auto-cierre)
        $( "#guardar_sucursal" ).submit(function( event ) {
            $('#guardar_datos').attr("disabled", true);
            var parametros = $(this).serialize();
            $.ajax({
                type: "POST",
                url: "ajax/nuevo_sucursal.php",
                data: parametros,
                beforeSend: function(objeto){
                    $("#resultados_ajax").html("Guardando...");
                },
                success: function(datos){
                    $("#resultados_ajax").html(datos);
                    $('#guardar_datos').attr("disabled", false);
                    load(1);
                    
                    // Auto-cerrar si es exitoso
                    if(datos.indexOf('alert-success') > -1){
                        setTimeout(function(){
                            $('#nuevoProducto').modal('hide'); 
                            document.getElementById("guardar_sucursal").reset(); 
                            $("#resultados_ajax").html(''); 
                        }, 2000);
                    }
                }
            });
            event.preventDefault();
        })

        // 4. EDITAR DATOS SUCURSAL (Con auto-cierre)
        $( "#editar_sucursal" ).submit(function( event ) {
            $('#actualizar_datos').attr("disabled", true);
            var parametros = $(this).serialize();
            $.ajax({
                type: "POST",
                url: "ajax/editar_sucursal.php",
                data: parametros,
                beforeSend: function(objeto){
                    $("#resultados_ajax2").html("Actualizando...");
                },
                success: function(datos){
                    $("#resultados_ajax2").html(datos);
                    $('#actualizar_datos').attr("disabled", false);
                    load(1);
                    
                    if(datos.indexOf('alert-success') > -1){
                        setTimeout(function(){
                            $('#myModal2').modal('hide'); 
                            $("#resultados_ajax2").html(''); 
                        }, 2000);
                    }
                }
            });
            event.preventDefault();
        })

// 5. LLENAR MODAL DE EDICIÓN
        function obtener_datos(id){
            var nombre = $("#nombre"+id).val();
            var nombre_stand = $("#nombre_stand"+id).val(); 
            var ruc = $("#ruc"+id).val();
            var direccion = $("#direccion"+id).val();
            var correo = $("#correo"+id).val();
            var telefono = $("#telefono"+id).val();
            var ubigeo = $("#ubigeo"+id).val();
            var departamento = $("#departamento"+id).val();
            var provincia = $("#provincia"+id).val();
            var distrito = $("#distrito"+id).val();
            var tipo_sucursal = $("#tipo_sucursal"+id).val(); // NUEVO
            
            $("#mod_nombre").val(nombre);
            $("#mod_nombre_stand").val(nombre_stand); 
            $("#mod_ruc").val(ruc);
            $("#mod_direccion").val(direccion);
            $("#mod_correo").val(correo);
            $("#mod_telefono").val(telefono);
            $("#mod_id").val(id);
            $("#mod_ubigeo").val(ubigeo);
            $("#mod_departamento").val(departamento);
            $("#mod_provincia").val(provincia);
            $("#mod_distrito").val(distrito);
            $("#mod_tipo_sucursal").val(tipo_sucursal); // ASIGNAMOS EL TIPO AL MODAL
        }

        // 6. FUNCIONES PARA EL MODAL DE LOGO (NUEVO)
        function cambiar_logo(id, nombre, foto){
            $("#logo_id").val(id);
            $("#logo_nombre").val(nombre);
            $("#imagefile").val(""); 
            $("#resultados_ajax_logo").html(""); 
            
            if(foto == "" || foto == "logo.jpg"){
                 $("#logo_previa").attr("src", "logo.jpg");
            } else {
                 $("#logo_previa").attr("src", "pdf/documentos/" + foto);
            }
        }

        $("#editar_logo_form").on('submit', function(e){
            e.preventDefault();
            var formData = new FormData(this);
            $.ajax({
                type: 'POST',
                url: 'ajax/editar_logo_sucursal.php',
                data: formData,
                contentType: false,
                cache: false,
                processData: false,
                beforeSend: function(){
                    $("#resultados_ajax_logo").html("Subiendo...");
                },
                success: function(data){
                    $("#resultados_ajax_logo").html(data);
                    load(1);
                    
                    if(data.indexOf('alert-success') > -1){
                        setTimeout(function(){
                            $('#modal_logo').modal('hide'); 
                            $("#resultados_ajax_logo").html(''); 
                        }, 2000);
                    }
                }
            });
        });
    </script>
</body>
</html>