<?php
// 1. INICIALIZACIÓN Y SEGURIDAD
session_start();
include('menu.php');
require_once ("config/db.php");
require_once ("config/conexion.php");

// Validar Sesión
if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
    header("location: login.php");
    exit;
}

// Validar Permisos (Índice 4 para Usuarios)
$sql1="select * from users where user_id='".$_SESSION['user_id']."'";
$rw1=mysqli_query($con,$sql1);
$rs1=mysqli_fetch_array($rw1);
$modulo=$rs1["accesos"];
$a = explode(".", $modulo); 

if($a[21]==0){
    header("location:error.php");    
    exit;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Lista de Usuarios | SoundCrow</title>
    <link rel="icon" href="logo.ico">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="fonts/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/custom.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        body { font-family: 'Poppins', sans-serif !important; background-color: #F0F2F5; color: #334155; }
        /* SISTEMA DE NOTIFICACIONES PREMIUM SC */
.toast-container-sc {
    position: fixed;
    top: 20px;
    right: 20px;
    z-index: 10000;
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.toast-sc {
    min-width: 320px;
    padding: 16px 22px;
    border-radius: 12px;
    color: white;
    display: flex;
    align-items: center;
    gap: 18px;
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.2);
    animation: toast-in 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275) forwards;
}

.toast-sc.hide {
    animation: toast-out 0.3s ease-in forwards;
}

/* Colores basados en tus imágenes */
.toast-error-sc { background: #ff4d4d; } /* Rojo exacto de tu captura */
.toast-success-sc { background: #10b981; } /* Verde esmeralda */

.toast-icon-sc { 
    font-size: 28px; 
    display: flex;
    align-items: center;
}

.toast-content-sc { display: flex; flex-direction: column; }

.toast-title-sc { 
    font-weight: 700; 
    font-size: 15px; 
    margin-bottom: 2px; 
    text-transform: capitalize;
}

.toast-desc-sc { 
    font-size: 13.5px; 
    opacity: 0.95; 
    line-height: 1.4;
}

/* Animaciones de entrada y salida */
@keyframes toast-in {
    from { transform: translateX(100%); opacity: 0; }
    to { transform: translateX(0); opacity: 1; }
}
@keyframes toast-out {
    from { transform: translateX(0); opacity: 1; }
    to { transform: translateX(100%); opacity: 0; }
}

        .sc-card {
            background: #ffffff;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.05);
            border: none;
            overflow: hidden;
            margin-bottom: 30px;
        }

        .sc-header {
            background: linear-gradient(90deg, #0a2463 0%, #2473f2 100%);
            padding: 20px 30px;
            color: white;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .sc-title {
            margin: 0;
            font-size: 18px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: white;
        }

        .sc-body { padding: 30px; }

        /* Botón Nuevo */
        .btn-sc-new {
            background-color: rgba(255,255,255,0.2);
            color: white;
            border: 1px solid rgba(255,255,255,0.4);
            border-radius: 50px;
            padding: 8px 20px;
            font-weight: 600;
            font-size: 13px;
            transition: all 0.3s;
        }
        .btn-sc-new:hover {
            background-color: white;
            color: #0a2463;
        }

        /* Input Búsqueda */
        .form-control-sc {
            border-radius: 8px;
            border: 1px solid #e2e8f0;
            padding: 10px 15px;
            height: 45px;
            background-color: #f8fafc;
            width: 100%;
            transition: 0.3s;
        }
        .form-control-sc:focus {
            background-color: #fff;
            border-color: #2473f2;
            box-shadow: 0 0 0 3px rgba(36, 115, 242, 0.1);
            outline: none;
        }
        
        /* ESTILO CARGA DE DOCUMENTOS */
        .file-upload {
            border: 2px dashed #cbd5e1;
            background: #f8fafc;
            padding: 15px;
            text-align: center;
            border-radius: 8px;
            cursor: pointer;
            transition: 0.3s;
        }
        .file-upload:hover { background: #f1f5f9; border-color: #2473f2; }
        
        /* LISTA DOCUMENTOS */
        #lista_documentos {
            max-height: 250px;
            overflow-y: auto;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            margin-top: 15px;
        }
    </style>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">
            
            <div class="col-md-3 left_col">
                <div class="left_col scroll-view">
                    <div class="clearfix"></div>
                    <?php menu2(); menu1(); ?>
                </div>
            </div>

            <?php menu3(); ?>
      
            <div class="right_col" role="main">
                <div class="">
                    <div class="page-title"></div>
                    <div class="clearfix"></div>

                    <div class="row">
                        <div class="container">
                            
                            <div class="sc-card">
                                <div class="sc-header">
                                    <div>
                                        <h3 class="sc-title"><i class="fa fa-users"></i> Gestión de Usuarios</h3>
                                    </div>
                                    <div>
                                        <button type='button' class="btn btn-sc-new" data-toggle="modal" data-target="#myModal">
                                            <i class="fa fa-plus"></i> Nuevo Usuario
                                        </button>
                                    </div>
                                </div>

                                <div class="sc-body">
                                    <?php
                                        include("modal/registro_usuarios.php");
                                        include("modal/editar_usuarios.php");
                                        include("modal/cambiar_password.php");
                                        include("modal/editar_foto_usuario.php"); 
                                    ?>
                                    
                                    <div class="modal fade" id="modalDocumento" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                                      <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                          <div class="modal-header" style="background:#0a2463; color:white;">
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                            <h4 class="modal-title" id="myModalLabel"><i class='fa fa-folder-open'></i> Expediente Digital</h4>
                                          </div>
                                          <div class="modal-body">
                                            
                                            <form id="form_documento" enctype="multipart/form-data" style="background:#f1f5f9; padding:15px; border-radius:8px;">
                                                <div id="resultados_doc"></div>
                                                <input type="hidden" name="mod_id_documento" id="mod_id_documento">
                                                
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label style="font-size:11px; text-transform:uppercase;">Tipo Documento</label>
                                                            <select class="form-control" name="tipo_documento" id="tipo_documento" onchange="verificarOtro(this.value)">
                                                                <option value="DNI">DNI</option>
                                                                <option value="CV">CV / HOJA DE VIDA</option>
                                                                <option value="CONTRATO">CONTRATO LABORAL</option>
                                                                <option value="REGISTRO DE INCIDENTES">REGISTRO DE INCIDENTES</option>
                                                                <option value="MEMORANDUM">MEMORANDUM</option>
                                                                <option value="ANTECEDENTES">ANTECEDENTES</option>
                                                                <option value="Otro">OTRO...</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group" id="div_otro_tipo" style="display:none;">
                                                            <input type="text" class="form-control" name="otro_tipo_documento" id="otro_tipo_documento" placeholder="Especifique nombre...">
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label style="font-size:11px; text-transform:uppercase;">Archivo</label>
                                                            <div class="file-upload" onclick="document.getElementById('documento_adjunto').click()" style="padding: 5px;">
                                                                <i class="fa fa-cloud-upload" style="color:#2473f2;"></i> <span style="font-size:11px;">Cargar</span>
                                                                <input type="file" name="documento_adjunto" id="documento_adjunto" style="display:none;" onchange="$('#info-file').text(this.files[0].name)">
                                                            </div>
                                                            <div id="info-file" style="font-size:10px; color:#666; margin-top:3px; white-space:nowrap; overflow:hidden; text-overflow:ellipsis;"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <button type="button" class="btn btn-success btn-block btn-sm" onclick="guardar_documento()">
                                                    <i class="fa fa-plus-circle"></i> AGREGAR AL EXPEDIENTE
                                                </button>
                                            </form>

                                            <hr style="margin: 15px 0;">
                                            
                                            <h5 style="font-weight:700; color:#475569;">Documentos Registrados</h5>
                                            <div id="lista_documentos">
                                                <div class="text-center" style="padding:20px;"><i class="fa fa-spin fa-spinner"></i> Cargando...</div>
                                            </div>

                                          </div>
                                          <div class="modal-footer">
                                            <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                    <form class="form-horizontal" onsubmit="event.preventDefault();">
                                        <div class="row" style="margin-bottom: 25px;">
                                            <div class="col-md-8">
                                                <input type="text" class="form-control-sc" id="q" placeholder="🔍 Buscar usuario por nombre, usuario o DNI..." onkeyup='load(1);'>
                                            </div>
                                            <div class="col-md-4 text-right">
                                                <span id="loader"></span>
                                            </div>
                                        </div>
                                    </form>

                                    <div id="resultados"></div>
                                    <div class='outer_div'></div>

                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
                <?php footer(); ?>
            </div>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="js/custom.js"></script>

    <script>
        $(document).ready(function(){
            load(1);
        });
        
        
        
        

        // --- 1. FUNCIÓN CARGAR TABLA PRINCIPAL ---
        function load(page){
            var q= $("#q").val();
            $.ajax({
                url:'./ajax/buscar_usuarios.php?action=ajax&page='+page+'&q='+q,
                success:function(data){
                    $(".outer_div").html(data).fadeIn('slow');
                }
            })
        }
        

        // --- 2. ELIMINAR USUARIO ---
        function eliminar(id, estado_actual){
            var q = $("#q").val();
            var mensaje = (estado_actual == 1) ? "¿Realmente deseas DESACTIVAR este usuario?" : "¿Realmente deseas ACTIVAR nuevamente a este usuario?";
            if (confirm(mensaje)){    
                $.ajax({
                    type: "GET",
                    url: "./ajax/buscar_usuarios.php",
                    data: "id="+id+"&q="+q, 
                    beforeSend: function(objeto){ $("#resultados").html("Procesando..."); },
                    success: function(datos){ $("#resultados").html(datos); load(1); setTimeout(function() { $(".alert").fadeOut(); }, 3000); }
                });
            }
        }

        // --- 3. GUARDAR NUEVO USUARIO ---
        $( "#guardar_usuario" ).submit(function( event ) {
            $('#guardar_datos').attr("disabled", true);
            var parametros = $(this).serialize();
            $.ajax({
                type: "POST", url: "ajax/nuevo_usuario.php", data: parametros,
                beforeSend: function(objeto){ $("#resultados_ajax").html("Guardando..."); },
                success: function(datos){ $("#resultados_ajax").html(datos); $('#guardar_datos').attr("disabled", false); load(1); }
            });
            event.preventDefault();
        })

        // --- 4. EDITAR USUARIO ---
        $( "#editar_usuario" ).submit(function( event ) {
            $('#actualizar_datos2').attr("disabled", true);
            var parametros = $(this).serialize();
            $.ajax({
                type: "POST", url: "ajax/editar_usuario.php", data: parametros,
                beforeSend: function(objeto){ $("#resultados_ajax2").html("Actualizando..."); },
                success: function(datos){ $("#resultados_ajax2").html(datos); $('#actualizar_datos2').attr("disabled", false); load(1); }
            });
            event.preventDefault();
        })

        $( "#editar_password" ).submit(function( event ) {
            $('#actualizar_datos3').attr("disabled", true);
            var parametros = $(this).serialize();
            $.ajax({
                type: "POST", url: "ajax/editar_password.php", data: parametros,
                beforeSend: function(objeto){ $("#resultados_ajax3").html("Actualizando..."); },
                success: function(datos){ $("#resultados_ajax3").html(datos); $('#actualizar_datos3').attr("disabled", false); }
            });
            event.preventDefault();
        })

        function cambiar_foto(id, nombre){
            $("#foto_user_id").val(id); $("#foto_nombre").val(nombre);
            $("#imagefile").val(""); $("#pre_img").attr("src", "images/logo.png"); $("#resultados_ajax_foto").html("");
        }

        $("#editar_foto_form").on('submit', function(e){
            e.preventDefault();
            var formData = new FormData(this);
            $.ajax({
                type: 'POST', url: 'ajax/editar_foto.php', data: formData, contentType: false, cache: false, processData: false,
                beforeSend: function(){ $("#resultados_ajax_foto").html("<div class='alert alert-info'>Subiendo imagen...</div>"); },
                success: function(data){ $("#resultados_ajax_foto").html(data); load(1); }
            });
        });

        // --- 8. FUNCIONES DOCUMENTOS (NUEVAS) ---
        
        // Abrir Modal y Cargar Lista
        function subir_documento(id){
            $("#mod_id_documento").val(id);
            $("#resultados_doc").html("");
            $("#info-file").text("");
            $("#form_documento")[0].reset();
            $("#div_otro_tipo").hide();
            
            $("#modalDocumento").modal("show");
            cargar_lista_documentos(id);
        }

        // Cargar Lista via AJAX
        function cargar_lista_documentos(id){
            $.ajax({
                url: "ajax/ver_documentos.php?id="+id,
                beforeSend: function(objeto){ $("#lista_documentos").html("<div class='text-center' style='padding:20px;'><i class='fa fa-spin fa-spinner'></i> Cargando...</div>"); },
                success: function(data){ $("#lista_documentos").html(data); }
            });
        }

        // Mostrar input "Otro"
        function verificarOtro(val){
            if(val == 'Otro'){ $("#div_otro_tipo").show(); $("#otro_tipo_documento").focus(); } 
            else { $("#div_otro_tipo").hide(); }
        }

        // Guardar Documento
        function guardar_documento(){
            var formData = new FormData(document.getElementById("form_documento"));
            var id = $("#mod_id_documento").val();
            
            $.ajax({
                url: "ajax/subir_documento.php",
                type: "post",
                dataType: "html",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                beforeSend: function(){ $("#resultados_doc").html("<div class='alert alert-info'>Subiendo...</div>"); },
                success: function(data){
                    if(data == 'ok'){
                        $("#resultados_doc").html("");
                        $("#form_documento")[0].reset();
                        $("#info-file").text("");
                        $("#div_otro_tipo").hide();
                        cargar_lista_documentos(id); // Recargar solo la lista
                    } else {
                        $("#resultados_doc").html(data);
                    }
                }
            });
        }

        // Eliminar Documento
        function eliminar_documento(id_doc){
            var user_id = $("#mod_id_documento").val();
            if(confirm("¿Estás seguro de eliminar este documento?")){
                $.ajax({
                    url: "ajax/eliminar_documento.php?id="+id_doc,
                    success: function(data){
                        if(data=='ok'){ cargar_lista_documentos(user_id); }
                        else { alert("Error al eliminar"); }
                    }
                });
            }
        }

        function get_user_id(id){ $("#user_id_mod").val(id); }

function obtener_datos(id){
    var nombres = $("#nombres"+id).val();
    var usuario = $("#usuario"+id).val();
    var email = $("#email"+id).val();
    var dni = $("#dni"+id).val();
    var dom = $("#dom"+id).val();
    var tel = $("#tel"+id).val();
    var hora = $("#hora"+id).val();
    var sucursal = $("#sucursal"+id).val();
    var f_nacimiento = $("#f_nacimiento"+id).val();
    var nivel = $("#nivel"+id).val();
    // NUEVO: Capturamos el código de barras
    var barcode = $("#barcode"+id).val(); 

    $("#mod_id").val(id); 
    $("#firstname2").val(nombres); 
    $("#user_name2").val(usuario);
    $("#user_email2").val(email); 
    $("#mod_dni").val(dni); 
    $("#dom").val(dom);
    $("#tel").val(tel); 
    $("#hora").val(hora); 
    $("#mod_sucursal").val(sucursal);
    $("#mod_f_nacimiento").val(f_nacimiento);
    $("#mod_nivel").val(nivel); 
    // NUEVO: Lo pasamos al modal de edición
    $("#mod_codigo_barras").val(barcode);
}
    </script>
</body>
</html>