<?php
session_start();
if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) { exit; }
require_once ("config/db.php");
require_once ("config/conexion.php");

$id_factura = intval($_GET['id']);
$sql_count = mysqli_query($con, "SELECT * FROM facturas WHERE id_factura='".$id_factura."'");
if (mysqli_num_rows($sql_count) == 0) { echo "<script>window.close();</script>"; exit; }
$rw_factura = mysqli_fetch_array($sql_count);
$numero_factura = strtoupper($rw_factura['numero_factura']);
$id_cliente = $rw_factura['id_cliente']; $id_tienda = $rw_factura['tienda']; $fecha_factura = date("d/m/Y", strtotime($rw_factura['fecha_factura'])); $total_venta = $rw_factura['total_venta'];

// MONEDA
$id_moneda = isset($rw_factura['moneda']) ? $rw_factura['moneda'] : 1;
$simbolo = ($id_moneda == 1) ? "S/" : "$";

// EMPRESA
$sql_suc = mysqli_query($con, "SELECT * FROM sucursal WHERE tienda='$id_tienda'"); $rw_suc = mysqli_fetch_array($sql_suc);
$mi_ruc = isset($rw_suc['ruc'])?$rw_suc['ruc']:''; $mi_nombre = isset($rw_suc['nombre'])?$rw_suc['nombre']:'MI EMPRESA'; $mi_direccion = isset($rw_suc['direccion'])?$rw_suc['direccion']:'';
$logo_url = "logo.png"; 

// PROVEEDOR
$sql_c = mysqli_query($con, "SELECT * FROM clientes WHERE id_cliente='$id_cliente'"); $rw_c = mysqli_fetch_array($sql_c);
$prov_nom = $rw_c['nombre_cliente']; $prov_doc = $rw_c['documento'];

// TOTALES
$total_pagado = 0; $sql_p = @mysqli_query($con, "SELECT SUM(importe_pago) as total FROM pagos WHERE id_factura='$id_factura'");
if ($sql_p) { $rw_p = mysqli_fetch_array($sql_p); $total_pagado = floatval($rw_p['total']); }
$deuda = $total_venta - $total_pagado; if($deuda < 0.1) $deuda = 0;

$estado_txt = ($deuda == 0) ? "PAGADO" : "PENDIENTE"; 
$badge_bg = ($deuda == 0) ? "#d1fae5" : "#fee2e2"; 
$badge_color = ($deuda == 0) ? "#065f46" : "#991b1b";
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8"><title>Compra <?php echo $numero_factura;?></title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; background: #f3f4f6; color: #1f2937; margin: 0; padding: 40px; }
        .invoice-card { max-width: 800px; margin: 0 auto; background: white; border-radius: 12px; box-shadow: 0 10px 25px -5px rgba(0,0,0,0.1); overflow: hidden; }
        .header { background: #111827; color: white; padding: 40px; display: flex; justify-content: space-between; align-items: flex-start; -webkit-print-color-adjust: exact; }
        .brand-container { display: flex; align-items: center; gap: 20px; }
        .logo-img { height: 60px; width: auto; background: white; padding: 5px; border-radius: 8px; }
        .brand h1 { margin: 0; font-size: 22px; font-weight: 700; text-transform: uppercase; line-height: 1.2; }
        .brand p { color: #9ca3af; margin: 4px 0 0; font-size: 13px; }
        .doc-info { text-align: right; }
        .doc-number { font-size: 24px; font-weight: 700; margin-top: 5px; color: white; }
        .grid-info { padding: 25px 40px; display: grid; grid-template-columns: 1fr 1fr; gap: 20px; border-bottom: 1px solid #e5e7eb; }
        .label { font-size: 10px; font-weight: 700; text-transform: uppercase; color: #6b7280; margin-bottom: 2px; letter-spacing: 0.5px; }
        .value { font-size: 14px; font-weight: 600; color: #111827; margin-bottom: 0; line-height: 1.4; }
        .sub-value { font-size: 13px; color: #4b5563; }
        .badge { background: <?php echo $badge_bg; ?>; color: <?php echo $badge_color; ?>; padding: 4px 10px; border-radius: 6px; font-size: 11px; font-weight: 700; display: inline-block; -webkit-print-color-adjust: exact; }
        .table-wrapper { padding: 0 40px; margin-top: 25px; }
        table { width: 100%; border-collapse: collapse; }
        th { text-align: left; padding: 12px 0; border-bottom: 2px solid #e5e7eb; font-size: 11px; text-transform: uppercase; color: #6b7280; font-weight: 700; }
        td { padding: 12px 0; border-bottom: 1px solid #f3f4f6; font-size: 13px; color: #374151; }
        .history-section { padding: 0 40px; margin-top: 35px; margin-bottom: 15px; }
        .history-title { font-size: 12px; font-weight: 700; color: #0a2463; text-transform: uppercase; margin-bottom: 10px; letter-spacing: 1px; }
        .table-history { width: 100%; border: 1px solid #e2e8f0; border-radius: 8px; overflow: hidden; }
        .table-history th { background-color: #f8fafc; padding: 10px 15px; border-bottom: 1px solid #e2e8f0; font-size: 10px; color: #64748b; -webkit-print-color-adjust: exact; }
        .table-history td { padding: 8px 15px; border-bottom: 1px solid #f1f5f9; font-size: 12px; color: #4b5563; }
        .footer { background: #f9fafb; padding: 30px 40px; display: flex; justify-content: flex-end; margin-top: 20px; -webkit-print-color-adjust: exact; border-top: 1px solid #e5e7eb; }
        .totals { width: 250px; }
        .row-total { display: flex; justify-content: space-between; margin-bottom: 8px; font-size: 13px; color: #4b5563; }
        .btn-print { display: block; width: 200px; margin: 30px auto; text-align: center; background: #2563eb; color: white; padding: 12px; border-radius: 8px; text-decoration: none; font-weight: 600; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        @media print { @page { margin: 0; size: auto; } body { background: white; margin: 0; padding: 0; } .invoice-card { width: 100%; max-width: 100%; box-shadow: none; border-radius: 0; margin: 0; } .btn-print { display: none; } .header { padding: 30px 40px; } .footer { break-inside: avoid; } }
    </style>
</head>
<body>
<div class="invoice-card">
    <div class="header">
        <div class="brand-container"><img src="<?php echo $logo_url; ?>" alt="Logo" class="logo-img" onerror="this.style.display='none'"><div class="brand"><h1><?php echo $mi_nombre; ?></h1><p>RUC: <?php echo $mi_ruc; ?></p><p><?php echo $mi_direccion; ?></p></div></div>
        <div class="doc-info"><div style="background:rgba(255,255,255,0.15); padding:4px 12px; border-radius:4px; display:inline-block; font-size:10px; font-weight:700; text-transform:uppercase; letter-spacing:1px;">Comprobante de Compra</div><div class="doc-number"><?php echo $numero_factura; ?></div><div style="font-size:12px; color:#9ca3af; margin-top:5px;">Emisión: <?php echo $fecha_factura; ?></div></div>
    </div>
    <div class="grid-info">
        <div><div class="label">Proveedor</div><div class="value"><?php echo $prov_nom; ?></div><div class="sub-value">RUC: <?php echo $prov_doc; ?></div></div>
        <div style="text-align: right; display:flex; flex-direction:column; justify-content:center; align-items:flex-end;"><div class="label" style="margin-bottom:5px;">Estado Actual</div><div class="badge"><?php echo $estado_txt; ?></div></div>
    </div>
    <div class="table-wrapper">
        <table><thead><tr><th width="10%" style="text-align:center;">Cant.</th><th width="60%">Descripción</th><th width="15%" style="text-align:right;">Precio</th><th width="15%" style="text-align:right;">Total</th></tr></thead>
        <tbody>
            <?php $sql_d = mysqli_query($con, "SELECT * FROM detalle_compra_manual WHERE id_factura='$id_factura'");
            if (mysqli_num_rows($sql_d)==0) { $sql_d = mysqli_query($con, "SELECT * FROM detalle_factura WHERE id_factura='$id_factura'"); }
            while ($r = mysqli_fetch_array($sql_d)) { $cant=$r['cantidad']; $prec=isset($r['precio'])?$r['precio']:$r['precio_venta']; $desc=isset($r['descripcion'])?$r['descripcion']:$r['nombre_producto']; ?>
            <tr><td style="text-align:center;"><?php echo number_format($cant,0); ?></td><td style="font-weight:500;"><?php echo $desc; ?></td><td style="text-align:right;"><?php echo $simbolo." ".number_format($prec,2); ?></td><td style="text-align:right; font-weight:600;"><?php echo $simbolo." ".number_format($cant*$prec,2); ?></td></tr>
            <?php } ?>
        </tbody></table>
    </div>
    <div class="history-section"><div class="history-title">Historial de Abonos</div>
        <table class="table-history"><thead><tr><th width="30%">FECHA PAGO</th><th width="40%">MÉTODO</th><th width="30%" style="text-align:right;">MONTO ABONADO</th></tr></thead>
        <tbody>
            <?php $sql_h = mysqli_query($con, "SELECT * FROM pagos WHERE id_factura='$id_factura' ORDER BY fecha_pago ASC");
            if(mysqli_num_rows($sql_h) > 0){ while($row_h = mysqli_fetch_array($sql_h)){ $fecha_p = date("d/m/Y", strtotime($row_h['fecha_pago'])); $monto_p = floatval($row_h['importe_pago']); $forma_p = $row_h['forma_pago']; switch ($forma_p) { case 1: $m="Efectivo"; break; case 2: $m="Transferencia"; break; case 3: $m="Yape/Plin"; break; case 4: $m="Tarjeta"; break; default: $m="Otro"; break; } ?>
            <tr><td><?php echo $fecha_p; ?></td><td><span style="background:#f1f5f9; padding:2px 8px; border-radius:4px; font-size:11px; font-weight:500;"><?php echo $m; ?></span></td><td style="text-align:right; color:#059669; font-weight:600;"><?php echo $simbolo." ".number_format($monto_p, 2); ?></td></tr>
            <?php }} else { echo "<tr><td colspan='3' style='text-align:center; padding:15px; color:#94a3b8; font-style:italic;'>Aún no se han registrado abonos.</td></tr>"; } ?>
        </tbody></table>
    </div>
    <div class="footer"><div class="totals">
        <div class="row-total" style="color: <?php echo ($deuda > 0) ? '#dc2626' : '#059669'; ?>; font-weight:700; font-size:16px; border-bottom:1px solid #e5e7eb; padding-bottom:10px; margin-bottom:10px;"><span><?php echo ($deuda > 0) ? 'Deuda Pendiente' : 'Saldo'; ?></span><span><?php echo $simbolo." ".number_format(($deuda > 0 ? $deuda : 0), 2); ?></span></div>
        <div class="row-total" style="color:#059669;"><span>Total Abonado</span><span>- <?php echo $simbolo." ".number_format($total_pagado, 2); ?></span></div>
        <div class="row-total" style="color:#111827; font-weight:700; font-size:15px;"><span>Total Compra</span><span><?php echo $simbolo." ".number_format($total_venta, 2); ?></span></div>
    </div></div>
</div>
<a href="javascript:window.print()" class="btn-print">IMPRIMIR COMPROBANTE</a>
</body>
</html>