<?php
session_start();
require_once ("config/db.php");
require_once ("config/conexion.php");

$id_factura = (isset($_GET['id_factura'])) ? intval($_GET['id_factura']) : 0;

$hash_recibido = (isset($_GET['hash'])) ? $_GET['hash'] : '';

// 1. SISTEMA DE SEGURIDAD (Validación de Hash)
$hash_esperado = md5($id_factura . 'SoundCrowSecret'); // Esta es tu llave secreta
if ($hash_recibido !== $hash_esperado) {
    die("<div style='text-align:center; padding:50px; font-family:sans-serif;'>
            <h2 style='color:#ef4444;'>Acceso Denegado</h2>
            <p>El enlace de este documento es inválido o no tiene permisos para visualizarlo.</p>
         </div>");
}

$sql_factura = mysqli_query($con, "SELECT * FROM facturas WHERE id_factura='$id_factura'");
$rw_factura = mysqli_fetch_array($sql_factura);

if (!$rw_factura) { die("Documento no encontrado."); }

// VARIABLES
$estado = $rw_factura['estado_factura'];
$folio = $rw_factura['folio'];
$numero = $rw_factura['numero_factura'];
$fecha = date("d/m/Y", strtotime($rw_factura['fecha_factura']));
$id_cliente = $rw_factura['id_cliente'];
$id_vendedor = $rw_factura['id_vendedor'];
$tienda = $rw_factura['tienda'];
$moneda = $rw_factura['moneda']; // Moneda solicitada
$condiciones = $rw_factura['condiciones']; 
$motivo_anulacion = $rw_factura['obs']; // Ahora lee de la columna correcta

// TIPO DE PAGO DINÁMICO
switch($condiciones){
    case 1: $tipo_pago = "EFECTIVO"; break;
    case 2: $tipo_pago = "YAPE / PLIN"; break;
    case 3: $tipo_pago = "TRANSFERENCIA"; break;
    case 4: $tipo_pago = "CRÉDITO"; break;
    case 5: $tipo_pago = "TARJETA"; break;
    default: $tipo_pago = "CONTADO"; break;
}

$color_main = "#0a2463"; $titulo_doc = "NOTA DE VENTA";
if ($estado == 8) { $titulo_doc = "COTIZACIÓN"; $color_main = "#f59e0b"; } 
elseif ($estado == 32) { $titulo_doc = "NOTA ANULADA"; $color_main = "#ef4444"; }

// DATOS SUCURSAL Y VENDEDOR
$sql_suc = mysqli_query($con, "SELECT * FROM sucursal WHERE tienda='$tienda'");
$rw_suc = mysqli_fetch_array($sql_suc);
$logo_path = str_replace("../", "", $rw_suc['foto']); 

$sql_v = mysqli_query($con, "SELECT nombres FROM users WHERE user_id='$id_vendedor'");
$rw_v = mysqli_fetch_array($sql_v);
$vendedor_nombre = ($rw_v) ? $rw_v['nombres'] : "Vendedor";

$sql_cli = mysqli_query($con, "SELECT * FROM clientes WHERE id_cliente='$id_cliente'");
$rw_cli = mysqli_fetch_array($sql_cli);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title><?php echo $titulo_doc; ?> | SoundCrow</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        /* MÁRGENES SOLICITADOS: 8mm vertical, 9.5mm horizontal */
        @page { size: A4; margin: 4mm 9.5mm; }
        body { background-color: #f1f5f9; font-family: 'Poppins', sans-serif; margin: 0; padding: 0; }
        
        .document-page { 
            background: white; width: 100%; max-width: 210mm; margin: 5px auto; 
            padding: 10px; position: relative; box-sizing: border-box; 
        }

        /* AQUÍ ESTÁ EL COLOR DEL ENCABEZADO */
        .premium-header { 
            color: white; padding: 9px 6px; border-radius: 10px; 
        }

        /* LOGO INTEGRADO SIN FONDO BLANCO */
        .sucursal-logo { height: 55px; background: transparent; filter: drop-shadow(0 2px 4px rgba(0,0,0,0.1)); }
        
        .doc-box { 
            background: linear-gradient(135deg, #0a2463 0%, <?php echo $color_main; ?> 100%); 
            border: 1px solid rgba(255,255,255,0.2); 
            border-radius: 8px; padding: 6px; text-align: center; 
        }

        .unified-card { 
            background: #f8fafc; border: 1px solid #e2e8f0; border-radius: 10px; 
            padding: 8px 15px; margin-bottom: 8px; display: flex; font-size: 10px;
        }
        
        .label-sc { font-size: 7.5px; font-weight: 700; color: #64748b; text-transform: uppercase; margin-bottom: 1px; }
        
        /* AJUSTE PARA 40 ITEMS EN UNA HOJA */
        .table-premium th { background: #0a2463; color: white; font-size: 9px; padding: 4px; text-transform: uppercase; text-align: center; }
        .table-premium td { font-size: 10px; padding: 3.5px 4px; border-bottom: 1px solid #f1f5f9; vertical-align: middle; line-height: 1; }

        .total-box { background: #0a2463; color: white; padding: 8px 12px; border-radius: 8px; width: 200px; margin-left: auto; }
        .monto-letras { border: 1px solid #e2e8f0; font-size: 9px; padding: 5px 10px; border-radius: 6px; font-weight: 600; margin-top: 5px; }
        .motivo-anulacion { background: #fee2e2; color: #b91c1c; border: 1px solid #ef4444; padding: 5px; font-size: 9px; border-radius: 5px; margin-bottom: 5px; }

        /* REGLA DE IMPRESIÓN CORREGIDA */
        @media print {
            body { 
                background: white; 
                -webkit-print-color-adjust: exact !important; /* Obliga a Chrome/Safari a imprimir colores */
                print-color-adjust: exact !important; /* Obliga a Firefox/otros a imprimir colores */
            }
            .no-print { display: none !important; }
            .document-page { margin: 0; padding: 0; width: 100%; box-shadow: none; }
        }
    </style>
    
</head>
<body>

<div class="container no-print mt-2 d-flex justify-content-center gap-2">
    <button onclick="window.print()" class="btn btn-primary rounded-pill btn-sm px-4 shadow-sm">IMPRIMIR</button>
</div>

<div class="document-page">
    <div class="premium-header">
        <div class="row align-items-center">
            <div class="col-7">
                <img src="<?php echo $logo_path; ?>" class="sucursal-logo" onerror="this.src='logo.png';">
                <h6 style="color: #0a2463;font-size: 21px;" class="fw-bold m-0 mt-1"><?php echo strtoupper($rw_suc['nombre']); ?></h6>
                <p style="color: #0a2463;font-size: 12px;" class="m-0" style="font-size: 8px; opacity: 0.9;"><?php echo $rw_suc['correo']; ?> | <?php echo $rw_suc['telefono']; ?></p>
            </div>
            <div class="col-5">
                <div class="doc-box">
                    <h6 class="m-0 fw-bold" style="font-size: 11px;">R.U.C. <?php echo $rw_suc['ruc']; ?></h6>
                    <div style="font-size: 7.5px; opacity: 0.9;">DIRECCIÓN: <?php echo strtoupper($rw_suc['direccion']); ?></div>
                    <div class="py-1 my-1" style="background:rgba(255,255,255,0.34); border-radius:4px; font-weight:700; font-size:9px;"><?php echo $titulo_doc; ?></div>
                    <h6 class="m-0 fw-bold"><?php echo $folio; ?> - <?php echo str_pad($numero, 8, "0", STR_PAD_LEFT); ?></h6>
                </div>
            </div>
        </div>
    </div>

    <?php if ($estado == 32 && !empty($motivo_anulacion)) { ?>
        <div class="motivo-anulacion"><strong>MOTIVO ANULACIÓN:</strong> <?php echo strtoupper($motivo_anulacion); ?></div>
    <?php } ?>

    <div class="unified-card">
        <div class="col-7 pe-3 border-end">
            <div class="label-sc">Información del Cliente</div>
            <div class="fw-bold text-uppercase" style="font-size: 10px;"><?php echo $rw_cli['nombre_cliente']; ?></div>
            <div class="col-5"><strong>DNI/RUC:</strong> <?php echo ($rw_cli['doc'] > 0) ? $rw_cli['doc'] : $rw_cli['dni']; ?></div>
            <div class="col-7"><strong>DIRECCIÓN:</strong> <?php echo $rw_cli['direccion_cliente']; ?></div>
        </div>
        <div class="col-5 ps-3">
            <div class="row">
                <div class="col-6"><div class="label-sc">F. Emisión</div><strong><?php echo $fecha; ?></strong></div>
                <div class="col-6 text-end"><div class="label-sc">Vendedor</div><strong><?php echo $vendedor_nombre; ?></strong></div>
            </div>
            <div class="row mt-2">
                <div class="col-7"><div class="label-sc">Tipo de Pago</div><strong style="color:<?php echo ($condiciones==4)?'#ef4444':'#0a2463';?>"><?php echo $tipo_pago; ?></strong></div>
                <div class="col-5 text-end"><div class="label-sc">Moneda</div><strong><?php echo ($moneda==1)?'SOLES':'DOLARES'; ?></strong></div>
            </div>
        </div>
    </div>

    <table class="table table-premium w-100">
        <thead>
            <tr>
                <th width="10%" style="border-top-left-radius: 12px;">CÓDIGO</th>
                <th width="45%">DESCRIPCIÓN</th>
                <th width="10%">MEDIDA</th>
                <th width="7%" class="text-center">CANT.</th>
                <th width="13%" class="text-center">P. UNIT</th>
                <th width="15%" class="text-center" style="border-top-right-radius: 12px;">TOTAL</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $tipo_det = ($estado == 32) ? 3 : $estado;
            $sumador = 0;
            $sql_items = mysqli_query($con, "SELECT d.*, p.nombre_producto, p.marca, p.modelo, p.codigo_producto, u.etiqueta 
                FROM detalle_factura d 
                LEFT JOIN products p ON d.id_producto = p.id_producto 
                LEFT JOIN und u ON p.und_pro = u.id_und 
                WHERE d.numero_factura='$numero' AND d.folio='$folio' AND d.tipo_doc='$tipo_det' AND d.tienda='$tienda'");
            
            while ($row = mysqli_fetch_array($sql_items)) {
                $descripcion = (isset($row['nombre_producto'])) ? $row['nombre_producto']." ".$row['marca']." ".$row['modelo'] : $row['id_producto'];
                $codigo = (isset($row['codigo_producto'])) ? $row['codigo_producto'] : "SER";
                $medida = (isset($row['etiqueta'])) ? $row['etiqueta'] : "UND";
                
                $item_total = $row['cantidad'] * $row['precio_venta'];
                $sumador += $item_total;
                ?>
                <tr>
                    <td class="text-center"><?php echo $codigo; ?></td>
                    <td class="fw-bold text-uppercase"><?php echo $descripcion; ?></td>
                    <td class="text-center"><?php echo $medida; ?></td>
                    <td class="text-center"><?php echo intval($row['cantidad']); ?></td>
                    <td class="text-end"><?php echo number_format($row['precio_venta'], 2); ?></td>
                    <td class="text-end fw-bold">S/. <?php echo number_format($item_total, 2); ?></td>
                </tr>
            <?php } ?>
        </tbody>
    </table>

    <div class="d-flex justify-content-between align-items-start mt-1">
        <div class="monto-letras flex-grow-1 me-3">
            <?php 
                $decimales = explode(".", number_format($sumador, 2, '.', ''));
                echo "SON: " . convertir($decimales[0]) . " Y " . $decimales[1] . " / 100 SOLES"; 
            ?>
        </div>
        <div class="total-box">
            <?php $sub = $sumador / 1.18; $igv_val = $sumador - $sub; ?>
            <div class="d-flex justify-content-between" style="font-size: 8px; opacity: 0.8;"><span>OP. GRAVADA:</span><span>S/. <?php echo number_format($sub, 2); ?></span></div>
            <div class="d-flex justify-content-between" style="font-size: 8px; opacity: 0.8;"><span>IGV (18%):</span><span>S/. <?php echo number_format($igv_val, 2); ?></span></div>
            <div class="d-flex justify-content-between mt-1 pt-1 border-top border-white-50"><span class="fw-bold">TOTAL:</span><span class="fw-bold fs-6">S/. <?php echo number_format($sumador, 2); ?></span></div>
        </div>
    </div>
</div>

<?php
// FUNCIONES DE CONVERSIÓN
function unidad($n){ switch($n){case 9:return "NUEVE";case 8:return "OCHO";case 7:return "SIETE";case 6:return "SEIS";case 5:return "CINCO";case 4:return "CUATRO";case 3:return "TRES";case 2:return "DOS";case 1:return "UN";case 0:return "";} }
function decena($n){ if($n>=90 && $n<=99){$t="NOVENTA ";if($n>90)$t.="Y ".(unidad($n-90));}else if($n>=80 && $n<=89){$t="OCHENTA ";if($n>80)$t.="Y ".(unidad($n-80));}else if($n>=70 && $n<=79){$t="SETENTA ";if($n>70)$t.="Y ".(unidad($n-70));}else if($n>=60 && $n<=69){$t="SESENTA ";if($n>60)$t.="Y ".(unidad($n-60));}else if($n>=50 && $n<=59){$t="CINCUENTA ";if($n>50)$t.="Y ".(unidad($n-50));}else if($n>=40 && $n<=49){$t="CUARENTA ";if($n>40)$t.="Y ".(unidad($n-40));}else if($n>=30 && $n<=39){$t="TREINTA ";if($n>30)$t.="Y ".(unidad($n-30));}else if($n>=20 && $n<=29){if($n==20)$t="VEINTE ";else $t="VEINTI".(unidad($n-20));}else if($n>=10 && $n<=19){switch($n){case 10:$t="DIEZ ";break;case 11:$t="ONCE ";break;case 12:$t="DOCE ";break;case 13:$t="TRECE ";break;case 14:$t="CATORCE ";break;case 15:$t="QUINCE ";break;case 16:$t="DIECISEIS ";break;case 17:$t="DIECISIETE ";break;case 18:$t="DIECIOCHO ";break;case 19:$t="DIECINUEVE ";break;}}else $t=unidad($n);return $t; }
function centena($n){ if($n>=100){if($n>=900 && $n<=999){$t="NOVECIENTOS ";if($n>900)$t.=(decena($n-900));}else if($n>=800 && $n<=899){$t="OCHOCIENTOS ";if($n>800)$t.=(decena($n-800));}else if($n>=700 && $n<=799){$t="SETECIENTOS ";if($n>700)$t.=(decena($n-700));}else if($n>=600 && $n<=699){$t="SEISCIENTOS ";if($n>600)$t.=(decena($n-600));}else if($n>=500 && $n<=599){$t="QUINIENTOS ";if($n>500)$t.=(decena($n-500));}else if($n>=400 && $n<=499){$t="CUATROCIENTOS ";if($n>400)$t.=(decena($n-400));}else if($n>=300 && $n<=399){$t="TRESCIENTOS ";if($n>300)$t.=(decena($n-300));}else if($n>=200 && $n<=299){$t="DOSCIENTOS ";if($n>200)$t.=(decena($n-200));}else if($n>=100 && $n<=199){if($n==100)$t="CIEN ";else $t="CIENTO ".(decena($n-100));}}else $t=decena($n);return $t; }
function miles($n){ if($n>=1000 && $n<2000){$t="MIL ".(centena($n%1000));}else if($n>=2000 && $n<10000){$t=unidad(Floor($n/1000))." MIL ".(centena($n%1000));}else $t=centena($n);return $t; }
function decmiles($n){ if($n==10000)$t="DIEZ MIL";else if($n>10000 && $n<20000){$t=decena(Floor($n/1000))."MIL ".(centena($n%1000));}else if($n>=20000 && $n<100000){$t=decena(Floor($n/1000))." MIL ".(miles($n%1000));}else $t=miles($n);return $t; }
function cienmiles($n){ if($n==100000)$t="CIEN MIL";else if($n>=100000 && $n<1000000){$t=centena(Floor($n/1000))." MIL ".(centena($n%1000));}else $t=decmiles($n);return $t; }
function millon($n){ if($n>=1000000 && $n<2000000){$t="UN MILLON ".(cienmiles($n%1000000));}else if($n>=2000000 && $n<10000000){$t=unidad(Floor($n/1000000))." MILLONES ".(cienmiles($n%1000000));}else $t=cienmiles($n);return $t; }
function convertir($n){ return millon($n); }
?>
</body>
</html>